/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Name(value="Give or Drop Item")
@Description(value={"Attempts to give an item to a player and if they dont have room it will drop instead."})
@Examples(value={"give or drop a diamond to player", "give or drop {_items::*} to all players"})
@Since(value={"2.14.0"})
public class EffGiveOrDrop
extends Effect {
    private Expression<ItemType> itemTypes;
    private Expression<Player> players;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.itemTypes = exprs[0];
        this.players = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        ItemType[] itemTypes = (ItemType[])this.itemTypes.getArray(event);
        List<ItemStack> itemStacks = ItemUtils.addItemTypesToList(Arrays.asList(itemTypes), null);
        if (itemStacks.isEmpty()) {
            for (ItemType itemType : itemTypes) {
                if (!itemType.getMaterial().isAir() && itemType.getMaterial().isItem()) continue;
                return;
            }
            return;
        }
        ItemStack[] itemStacksArray = itemStacks.toArray(itemStacks.toArray(new ItemStack[0]));
        for (Player player : (Player[])this.players.getArray(event)) {
            HashMap leftOvers = player.getInventory().addItem(itemStacksArray);
            if (leftOvers.isEmpty()) continue;
            Location location = player.getLocation();
            World world = location.getWorld();
            leftOvers.values().forEach(leftOver -> world.dropItem(location, leftOver));
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "give or drop " + this.itemTypes.toString(e, d) + " to " + this.players.toString(e, d);
    }

    static {
        Skript.registerEffect(EffGiveOrDrop.class, (String[])new String[]{"give or drop %itemtypes% to %players%"});
    }
}

