/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="List/Unlist Players")
@Description(value={"List/unlist a player for a player. (show/hide them in PlayerList for each other). Requires PaperMC 1.20.1+"})
@Examples(value={"unlist all players for player", "list (all players in world of player) for player"})
@Since(value={"2.17.0"})
public class EffPlayerListed
extends Effect {
    private boolean unlist;
    private Expression<Player> players;
    private Expression<Player> toUnlist;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.unlist = parseResult.hasTag("un");
        this.players = exprs[1];
        this.toUnlist = exprs[0];
        return true;
    }

    protected void execute(Event event) {
        for (Player player : (Player[])this.players.getArray(event)) {
            for (Player toUnlist : (Player[])this.toUnlist.getArray(event)) {
                if (this.unlist) {
                    player.unlistPlayer(toUnlist);
                    continue;
                }
                try {
                    player.listPlayer(toUnlist);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String list = this.unlist ? "unlist " : "list ";
        return list + this.toUnlist.toString(e, d) + " for " + this.players.toString(e, d);
    }

    static {
        if (Skript.methodExists(Player.class, (String)"isListed", (Class[])new Class[]{Player.class})) {
            Skript.registerEffect(EffPlayerListed.class, (String[])new String[]{"[:un]list %players% for %players%"});
        }
    }
}

