/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.destroystokyo.paper.entity.RangedEntity;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import com.shanebeestudios.skbee.api.util.MathUtil;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Ranged Attack")
@Description(value={"Make a RangedEntity perform a ranged attack. Requires PaperMC.", "\n`with charge` = How \"charged\" the attack is (how far back the bow was pulled for Bow attacks).", "This should be a value between 0 and 1, represented as targetDistance/maxDistance.", "\nRangedEntities: Drowned, Illusioner, Llama, Piglin, Pillager, Skeleton, Snowman, Stray, TraderLlama, Witch, Wither, WitherSkeleton."})
@Examples(value={"make last spawned entity range attack player with charge 0.5"})
@Since(value={"2.17.0"})
public class EffRangedAttack
extends Effect {
    private Expression<LivingEntity> entity;
    private Expression<LivingEntity> targets;
    private Expression<Number> charge;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entity = exprs[0];
        this.targets = exprs[1];
        this.charge = exprs[2];
        return true;
    }

    protected void execute(Event event) {
        Number chargeNum;
        LivingEntity entity = (LivingEntity)this.entity.getSingle(event);
        if (!(entity instanceof RangedEntity)) {
            return;
        }
        RangedEntity rangedEntity = (RangedEntity)entity;
        float charge = 1.0f;
        if (this.charge != null && (chargeNum = (Number)this.charge.getSingle(event)) != null) {
            charge = chargeNum.floatValue();
        }
        charge = MathUtil.clamp(charge, 0.0f, 1.0f);
        for (LivingEntity livingEntity : (LivingEntity[])this.targets.getArray(event)) {
            rangedEntity.rangedAttack(livingEntity, charge);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String charge = this.charge != null ? " with charge " + this.charge.toString(e, d) : "";
        return "make " + this.entity.toString(e, d) + " range attack " + this.targets.toString(e, d) + charge;
    }

    static {
        if (Skript.classExists((String)"com.destroystokyo.paper.entity.RangedEntity")) {
            Skript.registerEffect(EffRangedAttack.class, (String[])new String[]{"make %livingentity% range attack %livingentities% [with charge %-number%]"});
        }
    }
}

