/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Resource Pack Remove")
@Description(value={"Remove all resource packs from a player or remove resource packs from uuids. Requires Minecraft 1.20.4+"})
@Examples(value={"remove all resource packs from player", "remove resource pack with uuid {pack::1} from player", "remove resource packs with uuids {pack::*} from player"})
@Since(value={"3.4.0"})
public class EffResourcePackRemove
extends Effect {
    private boolean removeAll;
    private Expression<Player> players;
    private Expression<String> uuids;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        boolean bl = this.removeAll = matchedPattern == 0;
        if (matchedPattern == 1) {
            this.uuids = exprs[0];
            this.players = exprs[1];
        } else {
            this.players = exprs[0];
        }
        return true;
    }

    protected void execute(Event event) {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        if (!this.removeAll) {
            for (String string : (String[])this.uuids.getArray(event)) {
                try {
                    UUID u = UUID.fromString(string);
                    uuids.add(u);
                }
                catch (IllegalArgumentException ex) {
                    this.error("Invalid UUID: '" + string + "' // " + ex.getMessage());
                }
            }
        }
        for (String string : (Player[])this.players.getArray(event)) {
            if (this.removeAll) {
                string.removeResourcePacks();
                continue;
            }
            uuids.forEach(arg_0 -> ((Player)string).removeResourcePack(arg_0));
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String players = this.players.toString(e, d);
        if (this.removeAll) {
            return "remove all resource packs from " + players;
        }
        String uuids = this.uuids.toString(e, d);
        return "remove resourece pack[s] with uuid[s] " + uuids + " from " + players;
    }

    static {
        if (Skript.methodExists(Player.class, (String)"removeResourcePacks", (Class[])new Class[0])) {
            Skript.registerEffect(EffResourcePackRemove.class, (String[])new String[]{"remove all resource packs from %players%", "remove resource pack[s] with (uuid|id)[s] %strings% from %players%"});
        }
    }
}

