/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import com.shanebeestudios.skbee.api.util.SkriptUtils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Spawn Falling BlockData")
@Description(value={"Spawn a falling block data.", "This is a temp effect until Skript properly handles block data with spawning of falling blocks."})
@Examples(value={"le spawn falling snow[layers=3] above target block of player"})
@Since(value={"2.10.0"})
public class EffSpawnFallingBlockData
extends Effect {
    private Expression<BlockData> blockData;
    private Expression<Location> locations;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.blockData = exprs[0];
        this.locations = Direction.combine(exprs[1], exprs[2]);
        return true;
    }

    protected void execute(Event event) {
        BlockData blockData = (BlockData)this.blockData.getSingle(event);
        if (blockData == null) {
            return;
        }
        for (Location location : (Location[])this.locations.getArray(event)) {
            World world = location.getWorld();
            FallingBlock fallingBlock = world.spawnFallingBlock(location, blockData);
            SkriptUtils.setLastSpawned((Entity)fallingBlock);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "le spawn falling " + this.blockData.toString(e, d) + this.locations.toString(e, d);
    }

    static {
        Skript.registerEffect(EffSpawnFallingBlockData.class, (String[])new String[]{"(skbee|le) spawn falling %blockdata% [%directions% %locations%]"});
    }
}

