/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Spawner - Reset Timer")
@Description(value={"Resets the spawner timer for a spawner. Requires a PaperMC server."})
@Examples(value={"on spawner spawn:", "\treset spawner timer"})
@Since(value={"2.16.0"})
public class EffSpawnerResetTimer
extends Effect {
    private static final boolean SUPPORTS_RESET_TIMER;
    private Expression<Block> blocks;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!SUPPORTS_RESET_TIMER) {
            Skript.error((String)"The reset timer effect requires a PaperMC server.");
            return false;
        }
        this.blocks = exprs[0];
        return true;
    }

    protected void execute(Event event) {
        for (Block block : (Block[])this.blocks.getArray(event)) {
            BlockState blockState = block.getState();
            if (!(blockState instanceof CreatureSpawner)) continue;
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            spawner.resetTimer();
            spawner.update();
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "reset timer of " + this.blocks.toString(event, debug);
    }

    static {
        Skript.registerEffect(EffSpawnerResetTimer.class, (String[])new String[]{"reset spawner timer [of %blocks%]"});
        SUPPORTS_RESET_TIMER = Skript.methodExists(CreatureSpawner.class, (String)"resetTimer", (Class[])new Class[0]);
    }
}

