/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Transfer - Store Cookie")
@Description(value={"Store a cookie on a player for transfer. Requires Minecraft 1.20.5+", "NOTE: Only a string less than 5120 characters is accepted.", "NOTE: Cookies are stored on players across server transfers."})
@Examples(value={"store cookie \"look mah imma cookie\" with key \"my_id:super_mom_cookie\" on player"})
@Since(value={"3.5.0"})
public class EffTransferCookieStore
extends Effect {
    private Expression<String> cookie;
    private Expression<?> key;
    private Expression<Player> players;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.cookie = exprs[0];
        this.key = exprs[1];
        this.players = exprs[2];
        return true;
    }

    protected void execute(Event event) {
        String cookie = (String)this.cookie.getSingle(event);
        Object keyObject = this.key.getSingle(event);
        if (cookie == null || keyObject == null) {
            return;
        }
        NamespacedKey key = null;
        if (keyObject instanceof String) {
            String string = (String)keyObject;
            key = Util.getNamespacedKey(string, false);
        } else if (keyObject instanceof NamespacedKey) {
            NamespacedKey namespacedKey;
            key = namespacedKey = (NamespacedKey)keyObject;
        }
        if (key == null) {
            this.error("Invalid key: " + this.key.toString(event, true));
            return;
        }
        byte[] cookieBytes = cookie.getBytes();
        if (cookieBytes.length >= 5120) {
            this.error("Your cookie \ud83c\udf6a is too big. Minecraft limits to 5120 characters.");
            return;
        }
        for (Player player : (Player[])this.players.getArray(event)) {
            player.storeCookie(key, cookieBytes);
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return String.format("store cookie %s with key %s on %s", this.cookie.toString(e, d), this.key.toString(e, d), this.players.toString(e, d));
    }

    static {
        if (Skript.methodExists(Player.class, (String)"isTransferred", (Class[])new Class[0])) {
            Skript.registerEffect(EffTransferCookieStore.class, (String[])new String[]{"store cookie %string% with key %namespacedkey/string% on %players%"});
        }
    }
}

