/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.elements.other.type.Types;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="ArmorTrim - Material/Pattern")
@Description(value={"Represents the material and pattern of an armor trim.", "These cannot be changed, you'd have to create a new armor trim."})
@Examples(value={"set {_pattern} to trim pattern of armor trim of player's tool"})
@Since(value={"2.13.0"})
public class ExprArmorTrimMatPat
extends SimplePropertyExpression<ArmorTrim, Object> {
    private boolean pattern;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = parseResult.hasTag("pat");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Object convert(ArmorTrim armorTrim) {
        return this.pattern ? armorTrim.getPattern() : armorTrim.getMaterial();
    }

    @NotNull
    public Class<?> getReturnType() {
        return this.pattern ? TrimPattern.class : TrimMaterial.class;
    }

    @NotNull
    protected String getPropertyName() {
        String trim = this.pattern ? "pattern" : "material";
        return "armor trim " + trim;
    }

    static {
        if (Types.HAS_ARMOR_TRIM) {
            ExprArmorTrimMatPat.register(ExprArmorTrimMatPat.class, Object.class, (String)"[armor ]trim (material|pat:pattern)", (String)"armortrims");
        }
    }
}

