/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.EntityUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Attribute Modifiers of Item/LivingEntity")
@Description(value={"Get/change the attribute modifiers of an item/living entity.", "`default` = This option will return the vanilla modifiers of an item (only used for GET).", "`transient` = Non-persisent attribute modifier, will not save to the entity's NBT (only used for ADD) (Requires PaperMC).", "`modifier` will return a single modifier (will default to the 1st element of modifiers of that attribute type if more than 1 exists).", "`modifiers` will return a list of modifiers of that attribute type.", "**CHANGERS:**", "- `add` = Will add a modifier of an attribute type to an item/living entity.", "- `remove` = Remove a specific modifier of an attribute type from an item/living entity.", "- `delete` = Will delete all modifiers of an attribute type from an item/living entity."})
@Examples(value={"set {_mods::*} to attack damage modifier of player's tool", "set {_mod} to first element of attack damage modifier of player's tool", "set {_mod} to gravity attribute modifier of player", "delete gravity attribute modifier of player", "add scale modifier of player's tool to scale modifier of player"})
@Since(value={"3.5.9"})
public class ExprAttributeModifierOfItem
extends SimpleExpression<AttributeModifier> {
    private boolean single;
    private boolean defaultMods;
    private boolean trans;
    private Expression<Attribute> attribute;
    private Expression<?> objects;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.single = !parseResult.hasTag("s");
        this.defaultMods = parseResult.hasTag("default");
        this.trans = parseResult.hasTag("transient");
        if (this.trans && !EntityUtils.HAS_TRANSIENT) {
            Skript.error((String)"'transient' requires a PaperMC server.");
            return false;
        }
        this.attribute = exprs[0];
        this.objects = exprs[1];
        return true;
    }

    protected AttributeModifier @Nullable [] get(Event event) {
        Attribute attribute = (Attribute)this.attribute.getSingle(event);
        if (attribute == null) {
            return null;
        }
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
        for (Object object : this.objects.getArray(event)) {
            LivingEntity entity;
            AttributeInstance attributeInstance;
            Collection attributeModifiers;
            if (object instanceof ItemType) {
                ItemType itemType = (ItemType)object;
                ItemMeta itemMeta = itemType.getItemMeta();
                Collection collection = attributeModifiers = this.defaultMods ? itemType.getMaterial().getDefaultAttributeModifiers().get((Object)attribute) : itemMeta.getAttributeModifiers(attribute);
                if (attributeModifiers == null || attributeModifiers.isEmpty()) continue;
                if (this.single) {
                    modifiers.add((AttributeModifier)attributeModifiers.iterator().next());
                    continue;
                }
                modifiers.addAll(attributeModifiers);
                continue;
            }
            if (!(object instanceof LivingEntity) || (attributeInstance = (entity = (LivingEntity)object).getAttribute(attribute)) == null || (attributeModifiers = attributeInstance.getModifiers()).isEmpty()) continue;
            if (this.single) {
                modifiers.add((AttributeModifier)attributeModifiers.iterator().next());
                continue;
            }
            modifiers.addAll(attributeModifiers);
        }
        return modifiers.toArray(new AttributeModifier[0]);
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (this.defaultMods) {
            Skript.error((String)"Default Attribute Modifiers of an item cannot be changed.");
            return null;
        }
        if (mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{AttributeModifier[].class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Attribute attribute = (Attribute)this.attribute.getSingle(event);
        if (attribute == null) {
            return;
        }
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
        if (delta != null) {
            for (Object object : delta) {
                if (!(object instanceof AttributeModifier)) continue;
                AttributeModifier modifier = (AttributeModifier)object;
                modifiers.add(modifier);
            }
        }
        for (Object object : this.objects.getArray(event)) {
            LivingEntity entity;
            AttributeInstance attributeInstance;
            if (object instanceof ItemType) {
                ItemType itemType = (ItemType)object;
                ItemMeta itemMeta = itemType.getItemMeta();
                if (mode == Changer.ChangeMode.DELETE) {
                    itemMeta.removeAttributeModifier(attribute);
                } else if (!modifiers.isEmpty()) {
                    for (AttributeModifier modifier : modifiers) {
                        if (mode == Changer.ChangeMode.ADD) {
                            if (ItemUtils.hasAttributeModifier(itemMeta, attribute, modifier)) continue;
                            itemMeta.addAttributeModifier(attribute, modifier);
                            continue;
                        }
                        if (mode != Changer.ChangeMode.REMOVE) continue;
                        itemMeta.removeAttributeModifier(attribute, modifier);
                    }
                }
                itemType.setItemMeta(itemMeta);
                continue;
            }
            if (!(object instanceof LivingEntity) || (attributeInstance = (entity = (LivingEntity)object).getAttribute(attribute)) == null) continue;
            if (mode == Changer.ChangeMode.DELETE) {
                attributeInstance.getModifiers().forEach(arg_0 -> ((AttributeInstance)attributeInstance).removeModifier(arg_0));
                continue;
            }
            if (modifiers.isEmpty()) continue;
            for (AttributeModifier modifier : modifiers) {
                if (mode == Changer.ChangeMode.ADD) {
                    if (EntityUtils.hasAttributeModifier(entity, attribute, modifier)) continue;
                    if (this.trans) {
                        attributeInstance.addTransientModifier(modifier);
                        continue;
                    }
                    attributeInstance.addModifier(modifier);
                    continue;
                }
                if (mode != Changer.ChangeMode.REMOVE) continue;
                attributeInstance.removeModifier(modifier);
            }
        }
    }

    public boolean isSingle() {
        return this.single && this.objects.isSingle();
    }

    @NotNull
    public Class<? extends AttributeModifier> getReturnType() {
        return AttributeModifier.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String def = this.defaultMods ? "default " : "";
        String trans = this.trans ? "transient " : "";
        return def + trans + this.attribute.toString(e, d) + " attribute modifier[s] of " + this.objects.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprAttributeModifierOfItem.class, AttributeModifier.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[:default] [:transient] %attributetype% [attribute] modifier[:s] of %itemtypes/livingentities%"});
    }
}

