/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.destroystokyo.paper.entity.RangedEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Charging Attack")
@Description(value={"Represents a RangedEntity that is \"charging\" up an attack, by raising its hands.", "\nSetting requires a PaperMC server.", "\nRangedEntities: Drowned, Illusioner, Llama, Piglin, Pillager, Skeleton, Snowman, Stray, TraderLlama, Witch, Wither, WitherSkeleton."})
@Examples(value={"set charging attack of last spawned entity to true", "set {_charge} to charging attack of target entity of player", "if charging attack of target entity of player = true:"})
@Since(value={"2.17.0"})
public class ExprChargingAttack
extends SimplePropertyExpression<Entity, Boolean> {
    private static final boolean HAS_RANGED = Skript.classExists((String)"com.destroystokyo.paper.entity.RangedEntity");
    private static final boolean HAS_RAISED_HAND = Skript.methodExists(LivingEntity.class, (String)"isHandRaised", (Class[])new Class[0]);
    private static final boolean HAS_AGGRESSIVE = Skript.methodExists(Mob.class, (String)"isAggressive", (Class[])new Class[0]);

    @Nullable
    public Boolean convert(Entity entity) {
        if (HAS_RAISED_HAND && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.isHandRaised();
        }
        if (HAS_RANGED && entity instanceof RangedEntity) {
            RangedEntity rangedEntity = (RangedEntity)entity;
            return rangedEntity.isChargingAttack();
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (!HAS_RANGED && !HAS_AGGRESSIVE) {
            return null;
        }
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Entity[] entityArray;
        if (delta != null && (entityArray = delta[0]) instanceof Boolean) {
            Boolean bool = (Boolean)entityArray;
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                if (HAS_AGGRESSIVE && entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.setAggressive(bool.booleanValue());
                    continue;
                }
                if (!HAS_RANGED || !(entity instanceof RangedEntity)) continue;
                RangedEntity rangedEntity = (RangedEntity)entity;
                rangedEntity.setChargingAttack(bool.booleanValue());
            }
        }
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "charging attack";
    }

    static {
        if (HAS_RANGED || HAS_RAISED_HAND) {
            ExprChargingAttack.register(ExprChargingAttack.class, Boolean.class, (String)"charging attack", (String)"livingentities");
        }
    }
}

