/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity Origin Location")
@Description(value={"Represents the location where an entity originates from. Requires PaperMC."})
@Examples(value={"set {_loc} to origin of last spawned entity", "set {_loc} origin location of {_entity}", "if distance between {_entity} and origin of {_entity} > 10:"})
@Since(value={"3.3.0"})
public class ExprEntityOrigin
extends SimplePropertyExpression<Entity, Location> {
    private static final boolean HAS_ORIGIN = Skript.methodExists(Entity.class, (String)"getOrigin", (Class[])new Class[0]);

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!HAS_ORIGIN) {
            Skript.error((String)"Entity origin requires a PaperMC server.");
            return false;
        }
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Location convert(Entity entity) {
        return entity.getOrigin();
    }

    @NotNull
    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "origin location";
    }

    static {
        ExprEntityOrigin.register(ExprEntityOrigin.class, Location.class, (String)"origin[ location]", (String)"entities");
    }
}

