/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Entity Visibility")
@Description(value={"Get/set visibility for entities. Armor stands on all versions, ItemFrames on 1.15+ and LivingEntities on 1.16.3+"})
@Examples(value={"set visibility of target entity to false", "set {_v} to visibility of target entity", "if visibility of target entity is true:"})
@Since(value={"1.7.0"})
public class ExprEntityVisibility
extends PropertyExpression<Entity, Boolean> {
    private static final boolean ITEM_FRAME = Skript.methodExists(ItemFrame.class, (String)"setVisible", (Class[])new Class[]{Boolean.TYPE});
    private static final boolean LIVING_ENTITY = Skript.methodExists(LivingEntity.class, (String)"setInvisible", (Class[])new Class[]{Boolean.TYPE}) ? true : Skript.methodExists(Entity.class, (String)"setInvisible", (Class[])new Class[]{Boolean.TYPE});

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Boolean @NotNull [] get(@NotNull Event e, Entity @NotNull [] source) {
        return (Boolean[])this.get(source, entity -> {
            if (entity instanceof ArmorStand) {
                ArmorStand armorStand = (ArmorStand)entity;
                return armorStand.isVisible();
            }
            if (entity instanceof ItemFrame) {
                ItemFrame itemFrame = (ItemFrame)entity;
                if (ITEM_FRAME) {
                    return itemFrame.isVisible();
                }
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (LIVING_ENTITY) {
                    return !livingEntity.isInvisible();
                }
            }
            return null;
        });
    }

    public Class<?>[] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean[].class});
        }
        return null;
    }

    public void change(@NotNull Event event, @Nullable Object[] delta, @NotNull Changer.ChangeMode mode) {
        boolean visible = delta != null && (Boolean)delta[0] != false;
        for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
            if (entity instanceof ArmorStand) {
                ArmorStand armorStand = (ArmorStand)entity;
                armorStand.setVisible(visible);
                continue;
            }
            if (entity instanceof ItemFrame) {
                ItemFrame itemFrame = (ItemFrame)entity;
                if (ITEM_FRAME) {
                    itemFrame.setVisible(visible);
                    continue;
                }
            }
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!LIVING_ENTITY) continue;
            livingEntity.setInvisible(!visible);
        }
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "visibility of " + this.getExpr().toString(e, d);
    }

    static {
        ExprEntityVisibility.register(ExprEntityVisibility.class, Boolean.class, (String)"visibility", (String)"entities");
    }
}

