/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Give or Return Items")
@Description(value={"Attempts to add items to an inventory and will return a list of items that did not fit in the inventory."})
@Examples(value={"set {_i::*} to give or return diamond to player", "if {_i::*} is set:", "\tdrop {_i::*} at player", "", "set {_i::*} to add or return (a diamond and an emerald) to inventory of target block", "if {_i::*} is set:", "\tdrop {_i::*} above target block without velocity"})
@Since(value={"3.0.0"})
public class ExprGiveOrReturn
extends SimpleExpression<ItemType> {
    private Expression<ItemType> itemTypes;
    private Expression<Inventory> inventories;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.itemTypes = exprs[0];
        this.inventories = exprs[1];
        return true;
    }

    @Nullable
    protected ItemType[] get(Event event) {
        List<ItemStack> itemStacks = ItemUtils.addItemTypesToList(Arrays.asList((ItemType[])this.itemTypes.getArray(event)), null);
        ItemStack[] itemStacksArray = itemStacks.toArray(itemStacks.toArray(new ItemStack[0]));
        ArrayList returns = new ArrayList();
        for (Inventory inventory : (Inventory[])this.inventories.getArray(event)) {
            HashMap leftOvers = inventory.addItem(itemStacksArray);
            if (leftOvers.isEmpty()) continue;
            leftOvers.values().forEach(itemStack -> returns.add(new ItemType(itemStack)));
        }
        return returns.toArray(new ItemType[0]);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "give or return " + this.itemTypes.toString(e, d) + " to " + this.inventories.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprGiveOrReturn.class, ItemType.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"(give|add) or return %itemtypes% to %inventories%"});
    }
}

