/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.EntityUtils;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="NamespacedKey - Get")
@Description(value={"Get the namespaced key of an object or from a string.", "\nNote when getting key from string:", "NamespacedKeys are a string based key which consists of two components - a namespace and a key (ex: \"namespace:key\").", "Namespaces may only contain lowercase alphanumeric characters, periods, underscores, and hyphens.", "Minecraft uses the \"minecraft:\" namespace for built in objects.", "If a namespace is not provided, the Minecraft namespace will be used by default -> \"minecraft:your_key\"", "Keys may only contain lowercase alphanumeric characters, periods, underscores, hyphens, and forward slashes.", "Keep an eye on your console when using namespaced keys as errors will spit out when they're invalid.", "For more info please check out [**McWiki**](https://minecraft.wiki/w/Resource_location)."})
@Examples(value={"set {_key} to mc key of target block", "set {_key} to namespaced key of player's tool", "set {_key} to minecraft key of biome at player", "set {_n} to namespaced key from \"minecraft:log\"", "set {_custom} to namespaced key from \"my_server:custom_log\"", "set {_n} to namespaced key from \"le_test\""})
@Since(value={"2.6.0"})
public class ExprNamespacedKeyObject
extends SimplePropertyExpression<Object, NamespacedKey> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Expression objects = LiteralUtils.defendExpression(exprs[0]);
        this.setExpr(objects);
        return LiteralUtils.canInitSafely((Expression[])new Expression[]{objects});
    }

    @Nullable
    public NamespacedKey convert(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return Util.getNamespacedKey(string, true);
        }
        if (object instanceof Keyed) {
            Keyed keyed = (Keyed)object;
            return keyed.getKey();
        }
        if (object instanceof Block) {
            Block block = (Block)object;
            return block.getBlockData().getMaterial().getKey();
        }
        if (object instanceof BlockData) {
            BlockData blockData = (BlockData)object;
            return blockData.getMaterial().getKey();
        }
        if (object instanceof Entity) {
            Entity entity = (Entity)object;
            return entity.getType().getKey();
        }
        if (object instanceof EntityData) {
            EntityData entityData = (EntityData)object;
            EntityType entityType = EntityUtils.toBukkitEntityType((EntityData)entityData);
            if (entityType != null) {
                return entityType.getKey();
            }
        } else {
            EnchantmentType enchantmentType;
            Enchantment type;
            if (object instanceof ItemType) {
                ItemType itemType = (ItemType)object;
                return itemType.getMaterial().getKey();
            }
            if (object instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)object;
                return itemStack.getType().getKey();
            }
            if (object instanceof Slot) {
                Slot slot = (Slot)object;
                ItemStack item = slot.getItem();
                if (item != null) {
                    return item.getType().getKey();
                }
            } else if (object instanceof EnchantmentType && (type = (enchantmentType = (EnchantmentType)object).getType()) != null) {
                return type.getKey();
            }
        }
        return null;
    }

    @NotNull
    public Class<? extends NamespacedKey> getReturnType() {
        return NamespacedKey.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "namespaced key";
    }

    static {
        Skript.registerExpression(ExprNamespacedKeyObject.class, NamespacedKey.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"(minecraft|mc|namespaced|resource)[ ](key|id[entifier]|location)[s] [(from|of)] %objects%"});
    }
}

