/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.ObjectConverter;
import com.shanebeestudios.skbee.api.util.Util;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="NamespacedKey - Object From")
@Description(value={"Get an object from a namespaced key.", "This may come in handy in an instance you have a string version that doesn't match Skript and can't be parsed.", "Also supports some custom objects such as custom Enchantments in Minecraft 1.21+", "Currently supported types: attribute, biome, damage type, enchantment, entity type, game event, item type,", "particle, potion effect type, statistic, world."})
@Examples(value={"set {_n} to mc key from \"minecraft:zombie\"", "set {_e} to entity type from key {_n}", "set {_e} to entity type from key \"armadillo\"", "set {_e} to entity type from key \"minecraft:breeze\"", "spawn 1 of {_e} above target block", "", "set {_i} to itemtype from key \"minecraft:stone_sword\"", "give player 1 of {_i}", "", "set {_e} to enchantment from key \"minecraft:breach\"", "set {_e} to enchantment from key \"custom:my_custom_enchant\"", "set enchantment level of {_e} of player's tool to 3", "set {_e::*} to enchantments from keys \"minecraft:sharpness\" and \"bloop:shiver\""})
@Since(value={"2.17.0"})
public class ExprNamespacedKeyObjectFrom
extends SimpleExpression<Object> {
    private Literal<ClassInfo<?>> classInfo;
    private Expression<?> namespacedKey;
    private ObjectConverter<?> objectConverter;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.classInfo = (Literal)exprs[0];
        this.namespacedKey = exprs[1];
        this.objectConverter = ObjectConverter.getFromClass(((ClassInfo)this.classInfo.getSingle()).getC());
        if (this.objectConverter == null) {
            Skript.error((String)("SkBee does not have a NamespacedKey converter for '" + this.classInfo.toString() + "'"));
            return false;
        }
        return true;
    }

    protected Object @Nullable [] get(Event event) {
        ArrayList objects = new ArrayList();
        for (Object object : this.namespacedKey.getArray(event)) {
            if (object instanceof NamespacedKey) {
                NamespacedKey key = (NamespacedKey)object;
                objects.add(this.objectConverter.get(key));
                continue;
            }
            if (!(object instanceof String)) continue;
            String string = (String)object;
            NamespacedKey key = Util.getNamespacedKey(string, false);
            objects.add(this.objectConverter.get(key));
        }
        Object[] objectArray = (Object[])Array.newInstance(((ClassInfo)this.classInfo.getSingle()).getC(), objects.size());
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = objects.get(i);
        }
        return objectArray;
    }

    public boolean isSingle() {
        return this.namespacedKey.isSingle();
    }

    @NotNull
    public Class<?> getReturnType() {
        return ((ClassInfo)this.classInfo.getSingle()).getC();
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return this.classInfo.toString(e, d) + " from key " + this.namespacedKey.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprNamespacedKeyObjectFrom.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"%*classinfo% from key[s] %namespacedkeys/strings%"});
    }
}

