/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.SkriptUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Parse Effect - With Return")
@Description(value={"This will parse a string as an effect, execute it and return whether or not it executed.", "Works the same as Skript's 'effect commands'."})
@Examples(value={"command /parse <string>:", "\ttrigger:", "\t\tif parse effect arg-1 = false:", "\t\t\tsend \"ERROR: %arg-1%\""})
@Since(value={"2.15.0"})
public class ExprParseEffect
extends SimpleExpression<Boolean> {
    private Expression<String> effects;
    private Expression<CommandSender> sender;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.effects = exprs[0];
        this.sender = exprs[1];
        return true;
    }

    @Nullable
    protected Boolean[] get(Event event) {
        boolean pasred = true;
        ConsoleCommandSender sender = this.sender != null ? (CommandSender)this.sender.getSingle(event) : Bukkit.getConsoleSender();
        for (String string : (String[])this.effects.getArray(event)) {
            if (SkriptUtils.parseEffect(string, (CommandSender)sender)) continue;
            pasred = false;
        }
        return new Boolean[]{pasred};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        SyntaxStringBuilder builder = new SyntaxStringBuilder(e, d).append(new Object[]{"parse effect `", this.effects, "'"});
        if (this.sender != null) {
            builder.append(new Object[]{"from", this.sender});
        }
        return builder.toString();
    }

    static {
        Skript.registerExpression(ExprParseEffect.class, Boolean.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"parse effect[s] %strings% [from %-commandsender%]"});
    }
}

