/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Respawn Reason")
@Description(value={"Represents the reason the respawn event was called. Requires MC 1.19.4+"})
@Examples(value={"on respawn:", "\tif respawn reason = death respawn:", "\t\tgive player 10 diamonds"})
@Since(value={"2.8.4"})
public class ExprRespawnReason
extends SimpleExpression<PlayerRespawnEvent.RespawnReason> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ParserInstance.get().isCurrentEvent(PlayerRespawnEvent.class)) {
            Skript.error((String)"'respawn reason' can only be used in a respawn event.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    @Nullable
    protected PlayerRespawnEvent.RespawnReason[] get(Event event) {
        if (event instanceof PlayerRespawnEvent) {
            PlayerRespawnEvent playerRespawnEvent = (PlayerRespawnEvent)event;
            return new PlayerRespawnEvent.RespawnReason[]{playerRespawnEvent.getRespawnReason()};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends PlayerRespawnEvent.RespawnReason> getReturnType() {
        return PlayerRespawnEvent.RespawnReason.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "respawn reason";
    }

    static {
        if (Skript.methodExists(PlayerRespawnEvent.class, (String)"getRespawnReason", (Class[])new Class[0])) {
            Skript.registerExpression(ExprRespawnReason.class, PlayerRespawnEvent.RespawnReason.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"respawn reason"});
        }
    }
}

