/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity Shoot Bow - Force")
@Description(value={"Gets the force the arrow was launched with in an entity shoot bow event.", "This is a number between 0 and 1."})
@Examples(value={"on entity shoot bow:", "\tif shot force < 0.5:", "\t\tcancel event"})
@Since(value={"2.16.0"})
public class ExprShootBowForce
extends SimpleExpression<Number> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ParserInstance.get().isCurrentEvent(EntityShootBowEvent.class)) {
            Skript.error((String)("'" + parseResult.expr + "' can only be used in the entity shoot bow event."));
            return false;
        }
        return true;
    }

    @Nullable
    protected Number[] get(Event event) {
        if (event instanceof EntityShootBowEvent) {
            EntityShootBowEvent entityShootBowEvent = (EntityShootBowEvent)event;
            return new Number[]{Float.valueOf(entityShootBowEvent.getForce())};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "shoot force";
    }

    static {
        Skript.registerExpression(ExprShootBowForce.class, Number.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"shoot force", "shot force", "launch force", "bow force"});
    }
}

