/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entities Sorted by Distance")
@Description(value={"Sort entities by distance from a central location."})
@Examples(value={"loop all entities sorted by distance from player:", "set {_sort::*} to all mobs sorted by distance from {_loc}", "set {_p::*} to all players sorted by distance from {spawn}", "loop all mobs sorted by distance from player:"})
@Since(value={"3.0.0"})
public class ExprSortedEntities
extends SimpleExpression<Entity> {
    private Expression<Entity> entities;
    private Expression<Location> location;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.location = exprs[1];
        return true;
    }

    @Nullable
    protected Entity[] get(Event event) {
        Location location = (Location)this.location.getSingle(event);
        if (location == null) {
            this.error("Location is not set: " + this.location.toString(event, true));
            return null;
        }
        World world = location.getWorld();
        if (world == null) {
            this.error("Unknown world for location: " + Classes.toString((Object)location));
            return null;
        }
        List<Entity> collect = Arrays.stream((Entity[])this.entities.getArray(event)).filter(entity -> entity.getWorld() == world).sorted(Comparator.comparing(entity -> entity.getLocation().distanceSquared(location))).toList();
        return collect.toArray(new Entity[0]);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return this.entities.toString(e, d) + " sorted by distance from " + this.location.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprSortedEntities.class, Entity.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"%entities% sorted by distance from %location%"});
    }
}

