/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Spawner - Required Player Range")
@Description(value={"Get the maximum distance(squared) a player can be in order for a spawner to be active.", "If this value is less than 0, the spawner is always active (given that there are players online).", "Otherwise if the value is 0 the spawner is never active.", "Default value is 16."})
@Examples(value={"on place of mob spawner:", "\tset required player range of event-block to 0"})
@Since(value={"2.16.0"})
public class ExprSpawnerRequiredPlayerRange
extends SimplePropertyExpression<Block, Integer> {
    private static final int DEFAULT_ACTIVATION_RANGE = 16;

    @Nullable
    public Integer convert(Block block) {
        BlockState blockState = block.getState();
        if (blockState instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            return spawner.getRequiredPlayerRange();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE, Changer.ChangeMode.SET -> (Class[])CollectionUtils.array((Object[])new Class[]{Integer.class});
            case Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int changeValue = delta == null ? 16 : (Integer)delta[0];
        switch (mode) {
            case SET: 
            case RESET: {
                for (Block block : (Block[])this.getExpr().getArray(event)) {
                    BlockState blockState = block.getState();
                    if (!(blockState instanceof CreatureSpawner)) continue;
                    CreatureSpawner spawner = (CreatureSpawner)blockState;
                    spawner.setRequiredPlayerRange(changeValue);
                    spawner.update();
                }
                break;
            }
            case REMOVE: {
                changeValue = -changeValue;
            }
            case ADD: {
                for (Block block : (Block[])this.getExpr().getArray(event)) {
                    BlockState blockState = block.getState();
                    if (!(blockState instanceof CreatureSpawner)) continue;
                    CreatureSpawner spawner = (CreatureSpawner)blockState;
                    int value = spawner.getRequiredPlayerRange() + changeValue;
                    spawner.setRequiredPlayerRange(value);
                    spawner.update();
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    protected String getPropertyName() {
        return "spawner required activation range";
    }

    static {
        ExprSpawnerRequiredPlayerRange.register(ExprSpawnerRequiredPlayerRange.class, Integer.class, (String)"required (player|activation) range", (String)"blocks");
    }
}

