/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Spawner - Spawn Range")
@Description(value={"Get the radius around which a spawner will attempt to spawn mobs in.", "This area is square, includes the block the spawner is in, and is centered on the spawner's x,z coordinates - not the spawner itself.", "It is 2 blocks high, centered on the spawner's y-coordinate (its bottom); thus allowing mobs to spawn as high as its top surface and as low as 1 block below its bottom surface.", "Default value is 4."})
@Examples(value={"on place of mob spawner:", "\tset spawn range of event-block to random integer between 0 and 10"})
@Since(value={"2.16.0"})
public class ExprSpawnerSpawnRange
extends SimplePropertyExpression<Block, Integer> {
    private static final int DEFAULT_SPAWN_RANGE = 4;

    @Nullable
    public Integer convert(Block block) {
        BlockState blockState = block.getState();
        if (blockState instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            return spawner.getSpawnRange();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE, Changer.ChangeMode.SET -> (Class[])CollectionUtils.array((Object[])new Class[]{Integer.class});
            case Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int changeValue = delta == null ? 4 : (Integer)delta[0];
        switch (mode) {
            case SET: 
            case RESET: {
                for (Block block : (Block[])this.getExpr().getArray(event)) {
                    BlockState blockState = block.getState();
                    if (!(blockState instanceof CreatureSpawner)) continue;
                    CreatureSpawner spawner = (CreatureSpawner)blockState;
                    spawner.setSpawnRange(Math.max(changeValue, 0));
                    spawner.update();
                }
                break;
            }
            case REMOVE: {
                changeValue = -changeValue;
            }
            case ADD: {
                for (Block block : (Block[])this.getExpr().getArray(event)) {
                    BlockState blockState = block.getState();
                    if (!(blockState instanceof CreatureSpawner)) continue;
                    CreatureSpawner spawner = (CreatureSpawner)blockState;
                    int value = spawner.getSpawnRange() + changeValue;
                    spawner.setSpawnRange(Math.max(value, 0));
                    spawner.update();
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    protected String getPropertyName() {
        return "spawner spawn range";
    }

    static {
        ExprSpawnerSpawnRange.register(ExprSpawnerSpawnRange.class, Integer.class, (String)"[spawner] spawn range", (String)"blocks");
    }
}

