/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrushableBlock;
import org.bukkit.block.SuspiciousSand;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Suspicious Block - Item")
@Description(value={"Represents the item hiding in a Suspicious Block. Requires Minecraft 1.19.4+"})
@Examples(value={"set suspicious item of target block to a diamond", "delete suspicious item of block at location(199,10,-199, \"very_goodNames\")"})
@Since(value={"2.8.1, 2.14.0 (suspicious gravel)"})
public class ExprSuspiciousBlock
extends SimplePropertyExpression<Block, ItemType> {
    private static final boolean HAS_SUSPICIOUS_SAND = Skript.classExists((String)"org.bukkit.block.SuspiciousSand");
    private static final boolean HAS_BRUSHABLE_BLOCK = Skript.classExists((String)"org.bukkit.block.BrushableBlock");

    @Nullable
    public ItemType convert(Block block) {
        BlockState state = block.getState();
        ItemStack itemStack = null;
        if (HAS_BRUSHABLE_BLOCK && state instanceof BrushableBlock) {
            BrushableBlock brushableBlock = (BrushableBlock)state;
            itemStack = brushableBlock.getItem();
        } else if (HAS_SUSPICIOUS_SAND && state instanceof SuspiciousSand) {
            SuspiciousSand suspiciousSand = (SuspiciousSand)state;
            itemStack = suspiciousSand.getItem();
        }
        if (itemStack != null && !itemStack.getType().isAir()) {
            return new ItemType(itemStack);
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ItemType.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object object;
        ItemStack itemStack = null;
        if (delta != null && (object = delta[0]) instanceof ItemType) {
            ItemType itemType = (ItemType)object;
            itemStack = itemType.getRandom();
        }
        for (Block block : (Block[])this.getExpr().getArray(event)) {
            BlockState state = block.getState();
            if (HAS_BRUSHABLE_BLOCK && state instanceof BrushableBlock) {
                BrushableBlock brushableBlock = (BrushableBlock)state;
                brushableBlock.setItem(itemStack);
                brushableBlock.update();
                continue;
            }
            if (!HAS_SUSPICIOUS_SAND || !(state instanceof SuspiciousSand)) continue;
            SuspiciousSand suspiciousSand = (SuspiciousSand)state;
            suspiciousSand.setItem(itemStack);
            suspiciousSand.update();
        }
    }

    @NotNull
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "suspicious item";
    }

    static {
        if (HAS_BRUSHABLE_BLOCK || HAS_SUSPICIOUS_SAND) {
            ExprSuspiciousBlock.register(ExprSuspiciousBlock.class, ItemType.class, (String)"suspicious item", (String)"blocks");
        }
    }
}

