/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.LoopSection;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.region.TaskUtils;
import com.shanebeestudios.skbee.api.region.scheduler.Scheduler;
import com.shanebeestudios.skbee.api.region.scheduler.task.Task;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.MatchResult;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Repeating While Loop")
@Description(value={"Similar to Skript's while loop, this while loop will repeat at the given timespan.", "It is recommended to NOT use a wait within these sections, as the section will repeat regardless.", "", "**Patterns**:", "The 2nd pattern is only of concern if you are running Folia or have Paper schedulers enabled in the config, otherwise just use the first pattern.", "- `globally` = Will run this loop on the global scheduler (Use this for non entity/block related tasks).", "- `for %entity` = Will run this task for an entity, will follow the entity around (region wise)and will cancel itself when the entity is no longer valid.", "- `at %location%` = Will run this loop at a specific location (Use this for block related tasks)."})
@Examples(value={"on entity added to world:", "\tif event-entity is a wolf:", "\t\twhile event-entity is valid repeating every 1 seconds:", "\t\t\tset {_p} to nearest player in radius 15 around event-entity", "\t\t\tif {_p} is set:", "\t\t\t\tset target of event-entity to {_p}\n"})
@Since(value={"3.9.0"})
public class SecWhileRunnable
extends LoopSection {
    private Condition condition;
    private Expression<Timespan> timespan;
    private Expression<?> taskObject;
    private Task<?> task;
    private TriggerItem next;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        Literal literal;
        String group = ((MatchResult)parseResult.regexes.getFirst()).group();
        this.condition = Condition.parse((String)group, (String)"some error");
        if (this.condition == null) {
            return false;
        }
        this.timespan = exprs[0];
        Expression<Timespan> expression = this.timespan;
        if (expression instanceof Literal && ((Timespan)(literal = (Literal)expression).getSingle()).getAs(Timespan.TimePeriod.TICK) < 1L) {
            Skript.warning((String)"You cannot repeat less than 1 tick, defaulting to 1 tick.");
        }
        if (matchedPattern == 1) {
            this.taskObject = exprs[1];
        }
        this.loadCode(sectionNode);
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        Scheduler<?> scheduler;
        this.next = this.getNext();
        Timespan timespan = (Timespan)this.timespan.getSingle(event);
        if (timespan == null) {
            return this.next;
        }
        long ticks = timespan.getAs(Timespan.TimePeriod.TICK);
        if (ticks < 1L) {
            ticks = 1L;
        }
        if (this.taskObject != null) {
            Object object = this.taskObject.getSingle(event);
            if (object instanceof Entity) {
                Entity entity = (Entity)object;
                scheduler = TaskUtils.getEntityScheduler(entity);
            } else if (object instanceof Location) {
                Location location = (Location)object;
                scheduler = TaskUtils.getRegionalScheduler(location);
            } else {
                scheduler = TaskUtils.getGlobalScheduler();
            }
        } else {
            scheduler = TaskUtils.getGlobalScheduler();
        }
        if (scheduler == null) {
            return null;
        }
        AtomicReference<Object> originalVars = new AtomicReference<Object>(Variables.copyLocalVariables((Event)event));
        this.task = scheduler.runTaskTimer(() -> {
            Variables.setLocalVariables((Event)event, originalVars.get());
            if (this.condition.check(event)) {
                TriggerItem.walk((TriggerItem)this.first, (Event)event);
                originalVars.set(Variables.copyLocalVariables((Event)event));
            } else {
                this.exit(event);
                TriggerItem.walk((TriggerItem)this.next, (Event)event);
            }
        }, 1L, ticks);
        if (this.last != null) {
            this.last.setNext(null);
        }
        return null;
    }

    public String toString(Event e, boolean d) {
        String type = this.taskObject != null ? " for " + this.taskObject.toString(e, d) : " globally";
        return "while " + this.condition.toString(e, d) + " repeating every " + this.timespan.toString(e, d) + type;
    }

    public TriggerItem getActualNext() {
        return this.next;
    }

    public void exit(Event event) {
        this.task.cancel();
    }

    static {
        Skript.registerSection(SecWhileRunnable.class, (String[])new String[]{"while <.+> repeating every %timespan% [globally]", "while <.+> repeating every %timespan% [(at|on|for) %-entity/location%]"});
    }
}

