/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Recipe - Discovery")
@Description(value={"Lock/Unlock recipes for players. This uses the IDs we created earlier when registering recipes, you can also lock/unlock minecraft recipes. Requires MC 1.13+"})
@Examples(value={"unlock recipe \"smoking_cod\" for all players", "unlock recipe \"minecraft:baked_potato_from_smoking\" for all players", "unlock minecraft recipe \"baked_potato_from_smoking\" for all players", "unlock recipe \"some_plugin:some_recipe\" for all players", "on pickup of diamonds:", "\tdiscover recipe \"fancy_diamonds\" for player"})
@Since(value={"1.0.0"})
public class EffRecipeDiscovery
extends Effect {
    private Expression<String> recipes;
    private Expression<Player> players;
    private boolean discover;

    public boolean init(Expression<?>[] exprs, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.recipes = exprs[0];
        this.players = exprs[1];
        this.discover = pattern == 0;
        return true;
    }

    protected void execute(Event event) {
        String[] recipes;
        Player[] players = (Player[])this.players.getAll(event);
        for (String recipe : recipes = (String[])this.recipes.getAll(event)) {
            NamespacedKey key = Util.getNamespacedKey(recipe, false);
            if (key == null) continue;
            for (Player player : players) {
                if (this.discover) {
                    player.discoverRecipe(key);
                    continue;
                }
                player.undiscoverRecipe(key);
            }
        }
    }

    public String toString(Event e, boolean d) {
        String disc = this.discover ? "discover" : "undiscover";
        return disc + " recipe[s] " + this.recipes.toString(e, d) + " for " + this.players.toString(e, d);
    }

    static {
        Skript.registerEffect(EffRecipeDiscovery.class, (String[])new String[]{"(discover|unlock) [(custom|mc|minecraft)] recipe[s] [with id[s]] %strings% for %players%", "(undiscover|lock) [(custom|mc|minecraft)] recipe[s] [with id[s]] %strings% for %players%"});
    }
}

