/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.event.recipe.ShapedRecipeCreateEvent;
import com.shanebeestudios.skbee.api.event.recipe.ShapelessRecipeCreateEvent;
import com.shanebeestudios.skbee.api.recipe.RecipeUtil;
import java.util.Arrays;
import org.bukkit.event.Event;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Recipe - Ingredients")
@Description(value={"Set/add to the ingredients of a shaped/shapeless recipe.", "This is specifically used in the ingredients section of shaped/shapeless recipe section.", "`set ingredient` is used for shaped recipes.", "`add ingredient` is used for shapeless recipes."})
@Examples(value={"see shaped/shapeless recipe sections."})
@Since(value={"3.0.0"})
public class EffRecipeSetIngredient
extends Effect {
    private int pattern;
    private Expression<String> key;
    private Expression<?> ingredient;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        if (this.pattern == 0 && !ParserInstance.get().isCurrentEvent(ShapedRecipeCreateEvent.class)) {
            Skript.error((String)"`set ingredient` effect can only be used in an `ingredients` section of a shaped recipe section.");
            return false;
        }
        if (this.pattern == 1 && !ParserInstance.get().isCurrentEvent(ShapelessRecipeCreateEvent.class)) {
            Skript.error((String)"`add ingredients` effect can only be used in an `ingredients` section of a shapeless recipe section.");
            return false;
        }
        this.key = this.pattern == 0 ? exprs[0] : null;
        this.ingredient = exprs[this.pattern == 0 ? 1 : 0];
        return true;
    }

    protected void execute(Event event) {
        ShapelessRecipeCreateEvent shapelessEvent;
        ShapelessRecipe shapelessRecipe;
        Object ingredient = this.ingredient.getSingle(event);
        RecipeChoice recipeChoice = RecipeUtil.getRecipeChoice(ingredient);
        if (recipeChoice == null) {
            return;
        }
        if (this.pattern == 0 && event instanceof ShapedRecipeCreateEvent) {
            ShapedRecipeCreateEvent shapedEvent = (ShapedRecipeCreateEvent)event;
            String key = (String)this.key.getSingle(event);
            if (key == null || key.length() != 1) {
                return;
            }
            ShapedRecipe shapedRecipe = shapedEvent.getRecipe();
            if (Arrays.toString(shapedRecipe.getShape()).contains(key)) {
                char charKey = key.charAt(0);
                shapedRecipe.setIngredient(charKey, recipeChoice);
            }
        } else if (this.pattern == 1 && event instanceof ShapelessRecipeCreateEvent && (shapelessRecipe = (shapelessEvent = (ShapelessRecipeCreateEvent)event).getRecipe()).getChoiceList().size() < 9) {
            shapelessRecipe.addIngredient(recipeChoice);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        if (this.pattern == 0) {
            return "set ingredient of " + this.key.toString(e, d) + " to " + this.ingredient.toString(e, d);
        }
        return "add " + this.ingredient.toString(e, d) + " to ingredients";
    }

    static {
        Skript.registerEffect(EffRecipeSetIngredient.class, (String[])new String[]{"set ingredient (of|for) %string% to %itemstack/recipechoice/minecrafttag%", "add %itemstack/recipechoice/minecrafttag% to ingredients"});
    }
}

