/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.inventory.CraftingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.jetbrains.annotations.Nullable;

@Name(value="Recipe - Crafting Result from Items")
@Description(value={"Get the resulting item/id which would be crafted with a list of items.", "This requires either 4 or 9 items, to follow the 2x2 and 3x3 crafting grids respectively.", "Use `air` to represent blank slots in the crafting grid.", "I have no clue what the world is for since recipes are not per world, but Bukkit offers it so here we are."})
@Examples(value={"set {_barrel} to crafting result of oak planks, oak slab, oak planks, oak planks, air, oak planks, oak planks, oak slab, oak planks", "set {_carrotOnStick} to crafting result of fishing rod, air, air, carrot", "set {_diamondSwordId} to crafting result id of air, diamond, air, air, diamond, air, air, stick, air"})
@Since(value={"3.8.0"})
public class ExprCraftingResultFromItems
extends SimpleExpression<Object> {
    private static final World DEFAULT_WORLD = (World)Bukkit.getWorlds().get(0);
    private static final ItemStack AIR = new ItemStack(Material.AIR);
    private boolean id;
    private Expression<ItemType> items;
    private Expression<World> world;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.id = parseResult.hasTag("id");
        this.items = exprs[0];
        this.world = exprs[1];
        return true;
    }

    protected Object @Nullable [] get(Event event) {
        World world = this.world != null ? this.world.getOptionalSingle(event).orElse(DEFAULT_WORLD) : DEFAULT_WORLD;
        ItemStack[] itemStacks = new ItemStack[9];
        ItemType[] itemTypes = (ItemType[])this.items.getArray(event);
        if (itemTypes.length == 4) {
            itemStacks = new ItemStack[]{itemTypes[0].getRandom(), itemTypes[1].getRandom(), AIR, itemTypes[2].getRandom(), itemTypes[3].getRandom(), AIR, AIR, AIR, AIR};
        } else if (itemTypes.length == 9) {
            for (int i = 0; i < 9; ++i) {
                itemStacks[i] = itemTypes[i].getRandom();
            }
        } else {
            return null;
        }
        Recipe recipe = Bukkit.getCraftingRecipe((ItemStack[])itemStacks, (World)world);
        if (recipe != null) {
            if (this.id) {
                if (recipe instanceof CraftingRecipe) {
                    CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
                    return new String[]{craftingRecipe.getKey().toString()};
                }
            } else {
                ItemStack itemStack = recipe.getResult();
                if (itemStack.getType() != Material.AIR) {
                    return new ItemStack[]{itemStack};
                }
            }
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<?> getReturnType() {
        return this.id ? String.class : ItemStack.class;
    }

    public String toString(Event e, boolean d) {
        SyntaxStringBuilder builder = new SyntaxStringBuilder(e, d);
        builder.append((Object)"crafting result");
        builder.append((Object)(this.id ? "id" : "item"));
        builder.append(new Object[]{"from", this.items});
        if (this.world != null) {
            builder.append(new Object[]{"in world", this.world});
        }
        return builder.toString();
    }

    static {
        Skript.registerExpression(ExprCraftingResultFromItems.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"crafting result [item|:id] (of|from) [items] %itemtypes% [in %-world%]"});
    }
}

