/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Recipe - Result Slot")
@Description(value={"Represents the result slot of a crafting event.", "This can be changed."})
@Examples(value={"on crafter craft:", "\tif event-string = \"minecraft:diamond_sword\":", "\t\tset name of recipe result to \"Se\u00f1or Sword\"", "\telse:", "\t\tset recipe result to a stick named \"&cNice Try\"", "", "on preparing craft:", "\tset {_e} to event-string", "\tif {_e} = \"minecraft:diamond_shovel\":", "\t\tset name of recipe result to \"&cMr Shovel\""})
@Since(value={"3.6.1"})
public class ExprRecipeResultSlot
extends SimpleExpression<Slot> {
    public static final boolean HAS_CRAFTER_RECIPE = Skript.classExists((String)"org.bukkit.event.block.CrafterCraftEvent");

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        ParserInstance parser = this.getParser();
        if (HAS_CRAFTER_RECIPE && parser.isCurrentEvent(CrafterCraftEvent.class)) {
            return true;
        }
        if (parser.isCurrentEvent(new Class[]{CraftItemEvent.class, PrepareItemCraftEvent.class})) {
            return true;
        }
        Skript.error((String)("'" + parser.getCurrentEventName() + "' does not have a recipe result."));
        return false;
    }

    protected Slot @Nullable [] get(Event event) {
        InventoryEvent invEvent;
        Inventory inventory;
        Slot slot = null;
        if (HAS_CRAFTER_RECIPE && event instanceof CrafterCraftEvent) {
            final CrafterCraftEvent craftEvent = (CrafterCraftEvent)event;
            slot = new Slot(){

                @NotNull
                public ItemStack getItem() {
                    return craftEvent.getResult();
                }

                public void setItem(@Nullable ItemStack item) {
                    if (item == null) {
                        return;
                    }
                    craftEvent.setResult(item);
                }

                public int getAmount() {
                    return this.getItem().getAmount();
                }

                public void setAmount(int amount) {
                    ItemStack clone = this.getItem().clone();
                    clone.setAmount(amount);
                    this.setItem(clone);
                }

                public boolean isSameSlot(Slot other) {
                    return other.getItem() == this.getItem();
                }

                public String toString(Event event, boolean debug) {
                    return "crafter craft event result slot";
                }
            };
        } else if (event instanceof InventoryEvent && (inventory = (invEvent = (InventoryEvent)event).getInventory()) instanceof CraftingInventory) {
            final CraftingInventory craftingInventory = (CraftingInventory)inventory;
            slot = new Slot(){

                @Nullable
                public ItemStack getItem() {
                    return craftingInventory.getResult();
                }

                public void setItem(@Nullable ItemStack item) {
                    craftingInventory.setResult(item);
                }

                public int getAmount() {
                    ItemStack item = this.getItem();
                    if (item == null) {
                        return 0;
                    }
                    return item.getAmount();
                }

                public void setAmount(int amount) {
                    ItemStack item = this.getItem();
                    if (item != null) {
                        ItemStack clone = item.clone();
                        clone.setAmount(amount);
                        this.setItem(clone);
                    }
                }

                public boolean isSameSlot(Slot other) {
                    return other.getItem() == this.getItem();
                }

                public String toString(Event event, boolean debug) {
                    return "crafting inventory result slot";
                }
            };
        }
        if (slot != null) {
            return new Slot[]{slot};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Slot> getReturnType() {
        return Slot.class;
    }

    @NotNull
    public String toString(Event event, boolean b) {
        return "recipe result slot";
    }

    static {
        Skript.registerExpression(ExprRecipeResultSlot.class, Slot.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"recipe result [slot]"});
    }
}

