/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.recipe.RecipeUtil;
import com.shanebeestudios.skbee.api.skript.base.Section;
import com.shanebeestudios.skbee.api.util.SimpleEntryValidator;
import com.shanebeestudios.skbee.api.util.Util;
import io.papermc.paper.potion.PotionMix;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.potion.PotionBrewer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;

@Name(value="Recipe - Register Brewing Recipe")
@Description(value={"This section allows you to register a brewing recipe, define the ingredient and input. Requires a PaperMC server.", "\n`id` = The ID of this recipe.", "\n`result` = The resulting output ItemStack of this recipe (What the 3 bottle slots turn into).", "\n`ingredient` = Represents the ItemStack put in the top of the brewer (Accepts an ItemStack or RecipeChoice).", "\n`input` = Represents the ItemStack put in the 3 bottle slots (Accepts an ItemStack or RecipeChoice)."})
@Examples(value={"on load:", "\tregister brewing recipe:", "\t\tid: \"custom:brew_glow_diamond\"", "\t\tresult: diamond of unbreaking with all item flags", "\t\tingredient: glowstone dust", "\t\tinput: potato", "\t\t", "\tregister brewing recipe:", "\t\tid: \"custom:yummy_soup\"", "\t\tresult: mushroom stew named \"&bYummy Soup\"", "\t\tingredient: glowstone dust", "\t\tinput: water bottle"})
@Since(value={"3.0.0"})
public class SecRecipeBrewing
extends Section {
    private static EntryValidator VALIDATOR;
    private static PotionBrewer POTION_BREWER;
    private Expression<String> id;
    private Expression<ItemStack> result;
    private Expression<RecipeChoice> ingredient;
    private Expression<RecipeChoice> input;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        EntryContainer container = VALIDATOR.validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.id = (Expression)container.getOptional("id", false);
        if (this.id == null) {
            return false;
        }
        this.result = (Expression)container.getOptional("result", false);
        if (this.result == null) {
            return false;
        }
        this.ingredient = (Expression)container.getOptional("ingredient", false);
        if (this.ingredient == null) {
            return false;
        }
        this.input = (Expression)container.getOptional("input", false);
        return this.ingredient != null;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        this.execute(event);
        return super.walk(event, false);
    }

    private void execute(Event event) {
        String recipeId = (String)this.id.getSingle(event);
        if (recipeId == null) {
            this.error("Missing id");
            return;
        }
        NamespacedKey namespacedKey = Util.getNamespacedKey(recipeId, false);
        ItemStack result = (ItemStack)this.result.getSingle(event);
        RecipeChoice input = (RecipeChoice)this.input.getSingle(event);
        RecipeChoice ingredient = (RecipeChoice)this.ingredient.getSingle(event);
        if (namespacedKey == null) {
            this.error("Invalid id: " + recipeId);
            return;
        }
        if (result == null || !result.getType().isItem() || result.getType().isAir()) {
            this.error("Inavlid result: " + String.valueOf(result));
            return;
        }
        if (input == null) {
            this.error("Invalid input: " + String.valueOf(input));
            return;
        }
        if (ingredient == null) {
            this.error("Invalid ingredient: " + String.valueOf(ingredient));
            return;
        }
        POTION_BREWER.removePotionMix(namespacedKey);
        PotionMix potionMix = new PotionMix(namespacedKey, result, input, ingredient);
        POTION_BREWER.addPotionMix(potionMix);
        RecipeUtil.logBrewingRecipe(potionMix);
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "register brewing recipe";
    }

    static {
        POTION_BREWER = null;
        if (Skript.classExists((String)"io.papermc.paper.potion.PotionMix")) {
            SimpleEntryValidator builder = SimpleEntryValidator.builder();
            builder.addRequiredEntry("id", String.class);
            builder.addRequiredEntry("result", ItemStack.class);
            builder.addRequiredEntry("ingredient", RecipeChoice.class);
            builder.addRequiredEntry("input", RecipeChoice.class);
            POTION_BREWER = Bukkit.getPotionBrewer();
            VALIDATOR = builder.build();
            Skript.registerSection(SecRecipeBrewing.class, (String[])new String[]{"register [a] [new] (brewing recipe|potion mix)"});
        }
    }
}

