/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.registry.expression;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.tag.TagKey;
import java.util.ArrayList;
import org.bukkit.Keyed;
import org.bukkit.Registry;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Registry - TagKeys from Registry")
@Description(value={"Get all the tag keys that belong to a registry."})
@Examples(value={"loop tag keys of block registry:", "set {_keys::*} to tag keys of biome registry"})
@Since(value={"3.8.0"})
public class ExprRegistryTagKeys
extends SimpleExpression<TagKey> {
    private Expression<RegistryKey<Keyed>> registryKey;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.registryKey = exprs[0];
        return true;
    }

    protected TagKey<?> @Nullable [] get(Event event) {
        RegistryKey registryKey = (RegistryKey)this.registryKey.getSingle(event);
        if (registryKey == null) {
            return null;
        }
        Registry registry = RegistryAccess.registryAccess().getRegistry(registryKey);
        ArrayList tagKeys = new ArrayList();
        registry.getTags().forEach(tag -> tagKeys.add(tag.tagKey()));
        return tagKeys.toArray(new TagKey[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends TagKey> getReturnType() {
        return TagKey.class;
    }

    public String toString(Event e, boolean d) {
        return "tag keys of " + this.registryKey.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprRegistryTagKeys.class, TagKey.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"tag keys (of|from) %registrykey%"});
    }
}

