/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.EntityUtils;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Criteria;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Scoreboard - Criteria Create")
@Description(value={"Get one of the default Minecraft scoreboard criterias.", "You can also get a criteria bassed off a statistic.", "(see [**Scoreboard Criteria**](https://minecraft.wiki/w/Scoreboard#Criteria) on McWiki) or create your own."})
@Examples(value={"set {_c} to criteria with id \"health\"", "set {_c} to criteria from sprint_one_cm", "set {_c} to criteria from mine_block using diamond ore", "set {_c} to criteria from interact_with_anvil using diamond", "set {_c} to criteria from craft_item using diamond sword", "set {_c} to criteria from mob_kills using a player"})
@Since(value={"2.6.0"})
public class ExprCriteriaCreate
extends SimpleExpression<Criteria> {
    private Expression<String> id;
    private Expression<Statistic> statistic;
    @Nullable
    private Expression<?> object;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0) {
            this.id = exprs[0];
        } else {
            this.statistic = exprs[0];
            this.object = exprs[1];
        }
        return true;
    }

    @Nullable
    protected Criteria[] get(Event event) {
        if (this.id != null) {
            String id = (String)this.id.getSingle(event);
            if (id != null) {
                return new Criteria[]{Bukkit.getScoreboardCriteria((String)id)};
            }
        } else {
            Statistic statistic = (Statistic)this.statistic.getSingle(event);
            Object object = this.object != null ? this.object.getSingle(event) : null;
            Criteria criteria = null;
            if (statistic != null) {
                if (statistic.getType() == Statistic.Type.ENTITY) {
                    if (object instanceof EntityData) {
                        EntityData entityData = (EntityData)object;
                        EntityType entityType = EntityUtils.toBukkitEntityType((EntityData)entityData);
                        criteria = Criteria.statistic((Statistic)statistic, (EntityType)entityType);
                    }
                } else if (statistic.getType() == Statistic.Type.BLOCK) {
                    Material material = ExprCriteriaCreate.getMaterial(object);
                    if (material.isBlock()) {
                        criteria = Criteria.statistic((Statistic)statistic, (Material)material);
                    }
                } else if (statistic.getType() == Statistic.Type.ITEM) {
                    Material material = ExprCriteriaCreate.getMaterial(object);
                    if (material.isItem()) {
                        criteria = Criteria.statistic((Statistic)statistic, (Material)material);
                    }
                } else if (statistic.getType() == Statistic.Type.UNTYPED && object == null) {
                    criteria = Criteria.statistic((Statistic)statistic);
                }
            }
            if (criteria != null) {
                return new Criteria[]{criteria};
            }
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Criteria> getReturnType() {
        return Criteria.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        if (this.id != null) {
            return "criteria with id " + this.id.toString(e, d);
        }
        String using = this.object != null ? " using " + this.object.toString(e, d) : "";
        return "criteria from statistic " + this.statistic.toString(e, d) + using;
    }

    private static Material getMaterial(Object object) {
        if (object instanceof ItemType) {
            ItemType itemType = (ItemType)object;
            return itemType.getMaterial();
        }
        if (object instanceof BlockData) {
            BlockData blockData = (BlockData)object;
            return blockData.getMaterial();
        }
        return Material.AIR;
    }

    static {
        ArrayList<String> patterns = new ArrayList<String>(){
            {
                this.add("criteria with id %string%");
                if (SkBee.getPlugin().getPluginConfig().ELEMENTS_STATISTIC) {
                    this.add("criteria from [statistic] %statistic% [(using|with) %-itemtype/blockdata/entitydata%]");
                }
            }
        };
        Skript.registerExpression(ExprCriteriaCreate.class, Criteria.class, (ExpressionType)ExpressionType.COMBINED, (String[])patterns.toArray(new String[0]));
    }
}

