/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Scoreboard - Objective DisplaySlot")
@Description(value={"Get/Set the display slot of an objective."})
@Examples(value={"set display slot of {_objective} to player_list"})
@Since(value={"2.6.0"})
public class ExprObjDisplaySlot
extends SimpleExpression<DisplaySlot> {
    private Expression<Objective> objective;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.objective = exprs[0];
        return true;
    }

    @Nullable
    protected DisplaySlot[] get(Event event) {
        Objective objective = (Objective)this.objective.getSingle(event);
        if (objective == null) {
            return null;
        }
        return new DisplaySlot[]{objective.getDisplaySlot()};
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{DisplaySlot.class});
        }
        if (mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Objective objective = (Objective)this.objective.getSingle(event);
        if (objective == null) {
            return;
        }
        if (mode == Changer.ChangeMode.DELETE) {
            objective.setDisplaySlot(null);
        } else if (mode == Changer.ChangeMode.SET) {
            if (delta == null) {
                return;
            }
            Object object = delta[0];
            if (object instanceof DisplaySlot) {
                DisplaySlot displaySlot = (DisplaySlot)object;
                objective.setDisplaySlot(displaySlot);
            } else {
                this.error("Invalid object for display slot: " + Classes.toString((Object)delta[0]));
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends DisplaySlot> getReturnType() {
        return DisplaySlot.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "objective display slot of " + this.objective.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprObjDisplaySlot.class, DisplaySlot.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[objective] display[ ]slot of %objective%"});
    }
}

