/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.scoreboard.TeamUtils;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Team - Entries")
@Description(value={"Get the entries of a team. Entries can be entities/players or strings.", "**NOTE**: When returning as entities, if the entity isn't currently loaded in a world it won't return.", "OfflinePlayers will also not return. Use strings intead.", "**NOTE**: When returning as strings this will return the list how Minecraft stores it, player names and entity UUIDs.", "**NOTE**: adding/removing to/from team entries is now deprecated. Please directly add/remove to/from the team itself.", "See Team type docs for more info!"})
@Examples(value={"set {_team} to team named \"my-team\"", "clear team entries of {_team}", "kill team entries of team named \"mob-team\"", "set {_entities::*} to team entries of team named \"mobs\"", "set {_strings::*} to team entries as strings of team named \"mobs\""})
@Since(value={"1.16.0, 2.10.0 (strings)"})
public class ExprTeamEntries
extends SimpleExpression<Object> {
    private Expression<Team> team;
    private boolean strings;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.team = exprs[0];
        this.strings = parseResult.hasTag("string");
        return true;
    }

    protected Object[] get(Event event) {
        Team team = (Team)this.team.getSingle(event);
        if (team != null) {
            if (this.strings) {
                return team.getEntries().toArray(new String[0]);
            }
            return TeamUtils.getEntries(team).toArray(new Entity[0]);
        }
        return null;
    }

    @Nullable
    public @Nullable Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case ADD: 
            case REMOVE: {
                Skript.warning((String)"You can now add/remove entities/strings to/from teams directly without this expression. ex: 'add player to team named \"a-team\"'");
                return (Class[])CollectionUtils.array((Object[])new Class[]{OfflinePlayer[].class, Player[].class, Entity[].class, String[].class});
            }
            case DELETE: {
                return (Class[])CollectionUtils.array((Object[])new Class[0]);
            }
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Team team = (Team)this.team.getSingle(event);
        if (team != null) {
            if (mode == Changer.ChangeMode.DELETE) {
                team.getEntries().forEach(arg_0 -> ((Team)team).removeEntry(arg_0));
                return;
            }
            for (Object object : delta) {
                String entry = null;
                if (object instanceof OfflinePlayer) {
                    OfflinePlayer player = (OfflinePlayer)object;
                    entry = player.getName();
                } else if (object instanceof Entity) {
                    Entity entity = (Entity)object;
                    entry = entity.getUniqueId().toString();
                } else if (object instanceof String) {
                    String string;
                    entry = string = (String)object;
                }
                if (entry == null) continue;
                if (mode == Changer.ChangeMode.ADD) {
                    team.addEntry(entry);
                    continue;
                }
                team.removeEntry(entry);
            }
        }
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<?> getReturnType() {
        return this.strings ? String.class : Entity.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String string = this.strings ? "string" : "entity";
        return string + " entries of " + this.team.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprTeamEntries.class, Object.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"(:string|entity) team entries of %teams%", "%teams%'[s] (:string|entity) team entries", "[all] team entries [string:as strings] of %team%", "[all] team entries of %team% [string:as strings]", "%team%'[s] team entries [string:as strings]"});
    }
}

