/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="TextComponent - Replace Text")
@Description(value={"Replaces a given string with another string/text component.", "**NOTE:**", " - `regex` Defining the regex keyword will have the provided string be parsed as regex.", " - `first` Defining the first keyword will only replace the first instance. ", "If you're new to regex and want to see how it's parsed you can use https://regex101.com/ for debugging."})
@Examples(value={"component replace \"[item]\", \"[i]\" with getItemComponent(player's tool) in async chat message", "component regex replace \"\\[(item|i)]\" with getItemComponent(player's tool) in async chat message", "component replace first \"Mom!\" in {_message} with \"Dad!\""})
@Since(value={"2.18.0"})
public class EffComponentReplace
extends Effect {
    private boolean useRegex;
    private boolean replaceFirst;
    private Expression<String> patterns;
    private Expression<?> replacement;
    private Expression<ComponentWrapper> components;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.useRegex = parseResult.hasTag("regex");
        this.replaceFirst = parseResult.hasTag("first");
        this.patterns = exprs[0];
        this.components = exprs[2 - matchedPattern % 2];
        this.replacement = LiteralUtils.defendExpression(exprs[1 + matchedPattern % 2]);
        return LiteralUtils.canInitSafely((Expression[])new Expression[]{this.replacement});
    }

    protected void execute(Event event) {
        Object replacement = this.replacement.getSingle(event);
        String[] patterns = (String[])this.patterns.getArray(event);
        if (replacement == null || patterns.length == 0) {
            return;
        }
        this.components.changeInPlace(event, component -> {
            component.replace(this.useRegex, this.replaceFirst, replacement, patterns);
            return component;
        });
    }

    @NotNull
    public String toString(Event event, boolean debug) {
        SyntaxStringBuilder syntaxBuilder = new SyntaxStringBuilder(event, debug);
        syntaxBuilder.append((Object)"component");
        if (this.useRegex) {
            syntaxBuilder.append((Object)"regex");
        }
        syntaxBuilder.append((Object)"replace");
        if (this.replaceFirst) {
            syntaxBuilder.append((Object)"first");
        }
        syntaxBuilder.append(new Object[]{this.patterns, "with", this.replacement, "in", this.components});
        return syntaxBuilder.toString();
    }

    static {
        Skript.registerEffect(EffComponentReplace.class, (String[])new String[]{"component [:regex] replace [:first] %strings% with %object% in %~textcomponents%", "component [:regex] replace [:first] %strings% in %~textcomponents% with %object%"});
    }
}

