/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import net.kyori.adventure.audience.Audience;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Send")
@Description(value={"Send text components to audiences. You can also broadcast components as well.", "As of 1.16.0 you can also send action bar components to players and you can also send normal strings.", "`to %audiences%` = An audience is anything that can receieve a component (players, entities, console, worlds, server, etc).", "", "The optional sender (supported in Minecraft 1.16.4+) allows you to send components from a specific player.", "This is useful to make sure players can block messages using MC 1.16.4's new player chat ignore system.", "**NOTE**: `from %player%` is now deprecated (apparently hasn't worked in a long time)"})
@Examples(value={"set {_comp::1} to text component of \"hi player \"", "set {_comp::2} to text component of \"hover over me for a special message!\"", "set hover event of {_comp::2} to hover event showing \"OoO look ma I'm hovering!\"", "send component {_comp::*} to player", "send components {_comp::*} and \" ooo pretty!\" to player", "send actionbar component {_comp::1} to player", "", "# Send a message to your fellow teammates", "command /teambroadcast <msg:string>:", "\ttrigger:", "\t\tset {_team} to team of player", "\t\tset {_mini} to mini message from \"[TeamMessage from %player%] %{_msg}%\"", "\t\tsend component {_mini} to {_team}"})
@Since(value={"1.5.0"})
public class EffSendComponent
extends Effect {
    private Expression<Object> components;
    private Expression<Audience> audiences;
    private boolean action;
    private boolean broadcast;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.components = LiteralUtils.defendExpression(exprs[0]);
        Object object = this.audiences = matchedPattern == 0 ? exprs[1] : null;
        if (parseResult.hasTag("from")) {
            Skript.warning((String)"'from %player%' is no longer supported and will do nothing.");
        }
        this.action = matchedPattern == 0 && parseResult.mark == 1;
        this.broadcast = matchedPattern == 1;
        return LiteralUtils.canInitSafely((Expression[])new Expression[]{this.components});
    }

    protected void execute(Event event) {
        if (this.components == null) {
            return;
        }
        for (Object object : this.components.getArray(event)) {
            ComponentWrapper component;
            if (object instanceof ComponentWrapper) {
                ComponentWrapper componentWrapper;
                component = componentWrapper = (ComponentWrapper)object;
            } else if (object instanceof String) {
                String string = (String)object;
                component = ComponentWrapper.fromText(string);
            } else {
                String string = Classes.toString((Object)object);
                component = ComponentWrapper.fromText(string);
            }
            if (this.broadcast) {
                component.broadcast();
                continue;
            }
            for (Audience audience : (Audience[])this.audiences.getArray(event)) {
                if (this.action) {
                    component.sendActionBar(audience);
                    continue;
                }
                component.sendMessage(audience);
            }
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        SyntaxStringBuilder builder = new SyntaxStringBuilder(e, d).append((Object)(this.broadcast ? "broadcast" : "send")).append((Object)(this.action ? "action bar" : "text")).append((Object)(this.components.isSingle() ? "component" : "components")).append(this.components);
        if (this.audiences != null) {
            builder.append(new Object[]{"to", this.audiences});
        }
        return builder.toString();
    }

    static {
        Skript.registerEffect(EffSendComponent.class, (String[])new String[]{"send [(text|1:action[[ ]bar])] component[s] %objects% [to %audiences%] [from:from %-player%]", "broadcast [text] component[s] %objects% [from:from %-player%]"});
    }
}

