/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Color;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.Util;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Format")
@Description(value={"Change formatting options of text components. Most of these are pretty straight forward. ", "Insertion means the text that will copy to chat when a player shift-clicks the component (Might not be available on all versions). ", "Color supports color names as well as RGB color codes via Skript's RGB function (see examples).", "Fallback is the fallback text used in a translation component when the client cannot find said translation.", "Note: Shadow color format requires Minecraft 1.21.4+"})
@Examples(value={"set {_t} to text component from \"my fancy text component\"", "set bold format of {_t} to true", "set color format of {_t} to aqua", "set color format of {_t} to rgb(100, 0, 160)", "set shadow color format of {_t} to rgb(100,10,255,150)", "set insertion format of {_t} to \"ooooo\"", "set fallback format of {_t} to \"Le Fallback\""})
@Since(value={"1.5.1"})
public class ExprComponentFormat
extends PropertyExpression<ComponentWrapper, Object> {
    private static final int COLOR = 0;
    private static final int BOLD = 1;
    private static final int ITALIC = 2;
    private static final int OBFUSCATED = 3;
    private static final int STRIKETHROUGH = 4;
    private static final int UNDERLINE = 5;
    private static final int FONT = 6;
    private static final int INSERT = 7;
    private static final int FALLBACK = 8;
    private static final int SHADOW_COLOR = 9;
    private int pattern;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = parseResult.mark;
        if (!Util.IS_RUNNING_MC_1_21_4 && this.pattern == 9) {
            Skript.error((String)"Shadow color format requires Minecraft 1.21.4+");
            return false;
        }
        this.setExpr(exprs[0]);
        return true;
    }

    protected Object @NotNull [] get(@NotNull Event e, ComponentWrapper @NotNull [] source) {
        return this.get(source, component -> switch (this.pattern) {
            case 0 -> component.getColor();
            case 1 -> Boolean.valueOf(component.isBold());
            case 2 -> Boolean.valueOf(component.isItalic());
            case 3 -> Boolean.valueOf(component.isObfuscated());
            case 4 -> Boolean.valueOf(component.isStrikethrough());
            case 5 -> Boolean.valueOf(component.isUnderlined());
            case 6 -> component.getFont();
            case 7 -> component.getInsertion();
            case 8 -> component.getFallback();
            case 9 -> component.getShadowColor();
            default -> null;
        });
    }

    public Class<?>[] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{this.getReturnType()});
        }
        return null;
    }

    public void change(@NotNull Event e, @Nullable Object[] delta, @NotNull Changer.ChangeMode mode) {
        Object object;
        Object object2 = object = delta != null ? delta[0] : null;
        if (object == null) {
            return;
        }
        switch (this.pattern) {
            case 0: {
                if (!(object instanceof Color)) break;
                Color color = (Color)object;
                for (ComponentWrapper component : (ComponentWrapper[])this.getExpr().getArray(e)) {
                    component.setColor(color);
                }
                break;
            }
            case 1: {
                for (ComponentWrapper component : (ComponentWrapper[])this.getExpr().getArray(e)) {
                    boolean bold = !(object instanceof Boolean) || (Boolean)object != false;
                    component.setBold(bold);
                }
                break;
            }
            case 2: {
                for (ComponentWrapper component : (ComponentWrapper[])this.getExpr().getArray(e)) {
                    boolean italic = !(object instanceof Boolean) || (Boolean)object != false;
                    component.setItalic(italic);
                }
                break;
            }
            case 3: {
                for (ComponentWrapper component : (ComponentWrapper[])this.getExpr().getArray(e)) {
                    boolean obfuscated = !(object instanceof Boolean) || (Boolean)object != false;
                    component.setObfuscated(obfuscated);
                }
                break;
            }
            case 4: {
                for (ComponentWrapper component : (ComponentWrapper[])this.getExpr().getArray(e)) {
                    boolean strike = !(object instanceof Boolean) || (Boolean)object != false;
                    component.setStrikethrough(strike);
                }
                break;
            }
            case 5: {
                for (ComponentWrapper component : (ComponentWrapper[])this.getExpr().getArray(e)) {
                    boolean underline = !(object instanceof Boolean) || (Boolean)object != false;
                    component.setUnderlined(underline);
                }
                break;
            }
            case 6: {
                String font = object instanceof String ? (String)object : object.toString();
                for (ComponentWrapper componentWrapper : (ComponentWrapper[])this.getExpr().getArray(e)) {
                    componentWrapper.setFont(font);
                }
            }
            case 7: {
                String insert = object instanceof String ? (String)object : object.toString();
                for (ComponentWrapper component : (ComponentWrapper[])this.getExpr().getArray(e)) {
                    component.setInsertion(insert);
                }
                break;
            }
            case 8: {
                String fallback = object instanceof String ? (String)object : object.toString();
                for (ComponentWrapper component : (ComponentWrapper[])this.getExpr().getArray(e)) {
                    component.setFallback(fallback);
                }
            }
            case 9: {
                if (!(object instanceof Color)) break;
                Color color = (Color)object;
                for (ComponentWrapper component : (ComponentWrapper[])this.getExpr().getArray(e)) {
                    component.setShadowColor(color);
                }
                break;
            }
        }
    }

    @NotNull
    public Class<?> getReturnType() {
        return switch (this.pattern) {
            case 0, 9 -> Color.class;
            case 6, 7, 8 -> String.class;
            default -> Boolean.class;
        };
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String[] type = new String[]{"color", "bold", "italic", "obfuscated", "strikethrough", "underline", "font", "insertion", "fallback", "shadow color"};
        return type[this.pattern] + " format of " + this.getExpr().toString(e, d);
    }

    static {
        ExprComponentFormat.register(ExprComponentFormat.class, Object.class, (String)"(color|1:bold|2:italic|3:(obfuscate[d]|magic)|4:strikethrough|5:underline[d]|6:font|7:insert[ion]|8:fallback|9:shadow color) format", (String)"textcomponents");
    }
}

