/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Merge Components")
@Description(value={"Merge multiple components into one. If adding strings/texts, they will be converted into components."})
@Examples(value={"set {_t} to merge components {_t::*}", "set {_t} to merge components {_t::*} joined with newline"})
@Since(value={"2.4.0, 2.8.5 (delimiter), 2.15.0 (strings)"})
public class ExprMergeComponents
extends SimpleExpression<ComponentWrapper> {
    private Expression<?> components;
    private Expression<?> delimiter;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.components = exprs[0];
        this.delimiter = exprs[1];
        return true;
    }

    protected ComponentWrapper @Nullable [] get(Event event) {
        if (this.components == null) {
            return null;
        }
        Object[] array = this.components.getArray(event);
        ComponentWrapper[] components = new ComponentWrapper[array.length];
        for (int i = 0; i < array.length; ++i) {
            Object object = array[i];
            if (object instanceof ComponentWrapper) {
                ComponentWrapper componentWrapper;
                components[i] = componentWrapper = (ComponentWrapper)object;
                continue;
            }
            object = array[i];
            if (object instanceof String) {
                String string = (String)object;
                components[i] = ComponentWrapper.fromText(string);
                continue;
            }
            components[i] = ComponentWrapper.empty();
        }
        if (this.delimiter != null) {
            Object delimiter = this.delimiter.getSingle(event);
            if (delimiter instanceof String) {
                String string = (String)delimiter;
                return new ComponentWrapper[]{ComponentWrapper.fromComponents(components, ComponentWrapper.fromText(string))};
            }
            if (delimiter instanceof ComponentWrapper) {
                ComponentWrapper componentWrapper = (ComponentWrapper)delimiter;
                return new ComponentWrapper[]{ComponentWrapper.fromComponents(components, componentWrapper)};
            }
        }
        return new ComponentWrapper[]{ComponentWrapper.fromComponents(components)};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends ComponentWrapper> getReturnType() {
        return ComponentWrapper.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "merge components " + this.components.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprMergeComponents.class, ComponentWrapper.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"merge components %textcomponents/strings% [[join[ed]] (with|using) %-textcomponent/string%]"});
    }
}

