/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.skript.base.SimplePropertyExpression;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import net.kyori.adventure.text.Component;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.Skull;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Block Name")
@Description(value={"Get/set/delete the custom name of a block. This will work on container blocks and skulls.", "Skulls require Paper 1.21.4(Build 214)+", "Even though the custom name of any skull can be set, only a player head will retain its name when broken (Skeleton/creeper/etc skulls will not)."})
@Examples(value={"set {_name} to component block name of target block", "set component block name of target block to mini message from \"<rainbow>Mr Potato Head!\"", "delete component block name of target block"})
@Since(value={"3.10.1"})
public class ExprNameBlock
extends SimplePropertyExpression<Block, ComponentWrapper> {
    private static final boolean HAS_SKULL_NAME = Skript.methodExists(Skull.class, (String)"customName", (Class[])new Class[0]);

    @Nullable
    public ComponentWrapper convert(Block block) {
        BlockState state = block.getState();
        Component component = null;
        if (state instanceof Container) {
            Container container = (Container)state;
            component = container.customName();
        } else if (state instanceof Skull) {
            Skull skull = (Skull)state;
            if (HAS_SKULL_NAME) {
                component = skull.customName();
            }
        }
        if (component != null) {
            return ComponentWrapper.fromComponent(component);
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ComponentWrapper.class});
        }
        if (mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    @Override
    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        Object object;
        Component name = null;
        if (delta != null && (object = delta[0]) instanceof ComponentWrapper) {
            ComponentWrapper cw = (ComponentWrapper)object;
            name = cw.getComponent();
        }
        for (Block block : (Block[])this.getExpr().getArray(event)) {
            this.setName(block, name);
        }
    }

    private void setName(Block block, Component name) {
        BlockState state = block.getState(false);
        if (state instanceof Container) {
            Container container = (Container)state;
            container.customName(name);
        } else if (state instanceof Skull) {
            Skull skull = (Skull)state;
            if (HAS_SKULL_NAME) {
                skull.customName(name);
            }
        }
    }

    protected String getPropertyName() {
        return "component block custom name";
    }

    public Class<? extends ComponentWrapper> getReturnType() {
        return ComponentWrapper.class;
    }

    static {
        ExprNameBlock.register(ExprNameBlock.class, ComponentWrapper.class, (String)"component [custom] block name", (String)"block");
    }
}

