/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import com.shanebeestudios.skbee.api.util.Util;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.jetbrains.annotations.Nullable;

@Name(value="Scoreboard - Objective Score Custom Name")
@Description(value={"Get/change the custom name of the score of an objective for an entry.", "Supports both components and strings.", "Requires Paper 1.20.4+", "- `[component]` = Will return as a text component (for set this doesn't matter).", "- `delete` = Will set the name to an empty component.", "- `reset` = Will reset back to the original name."})
@Examples(value={"set component custom score name of player for {_someObjective} to mini message from \"Some Name\"", "set custom score name of player for {_someObjective} to \"Some Name\"", "delete custom score name of \"bob\" for {_someObjective}", "reset custom score name of all entities for {_someObjective}"})
@Since(value={"3.9.0"})
public class ExprObjectiveScoreCustomName
extends SimpleExpression<Object> {
    private boolean isComponent;
    private Expression<?> entries;
    private Expression<Objective> objective;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.isComponent = parseResult.hasTag("component");
        this.entries = exprs[0];
        this.objective = exprs[1];
        return true;
    }

    protected Object @Nullable [] get(Event event) {
        Objective objective = (Objective)this.objective.getSingle(event);
        if (objective == null) {
            this.error("Missing objective: " + this.objective.toString(event, true));
            return null;
        }
        ArrayList<Object> comps = new ArrayList<Object>();
        for (Object object : this.entries.getArray(event)) {
            Score score;
            if (object instanceof Entity) {
                Entity entity = (Entity)object;
                score = objective.getScoreFor(entity);
            } else {
                if (!(object instanceof String)) continue;
                String string = (String)object;
                score = objective.getScore(string);
            }
            Component component = score.customName();
            if (component == null) continue;
            ComponentWrapper cw = ComponentWrapper.fromComponent(component);
            comps.add(this.isComponent ? cw : cw.toString());
        }
        return comps.toArray(this.isComponent ? new ComponentWrapper[]{} : new String[]{});
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ComponentWrapper.class, String.class});
        }
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        Objective objective = (Objective)this.objective.getSingle(event);
        if (objective == null) {
            this.error("Missing objective: " + this.objective.toString(event, true));
            return;
        }
        Component component = null;
        if (delta != null) {
            Object object = delta[0];
            if (object instanceof ComponentWrapper) {
                ComponentWrapper cw = (ComponentWrapper)object;
                component = cw.getComponent();
            } else {
                object = delta[0];
                if (object instanceof String) {
                    String string = (String)object;
                    component = Component.text((String)string);
                }
            }
        }
        for (Object object : this.entries.getArray(event)) {
            Score score;
            if (object instanceof Entity) {
                Entity entity = (Entity)object;
                score = objective.getScoreFor(entity);
            } else {
                if (!(object instanceof String)) continue;
                String string = (String)object;
                score = objective.getScore(string);
            }
            if (mode == Changer.ChangeMode.SET) {
                if (component == null) {
                    this.error("Missing component: " + this.objective.toString(event, true));
                    continue;
                }
                score.customName(component);
                continue;
            }
            if (mode == Changer.ChangeMode.DELETE) {
                score.customName((Component)Component.empty());
                continue;
            }
            score.customName(component);
        }
    }

    public boolean isSingle() {
        return this.entries.isSingle();
    }

    public Class<?> getReturnType() {
        return this.isComponent ? ComponentWrapper.class : String.class;
    }

    public String toString(Event e, boolean d) {
        return new SyntaxStringBuilder(e, d).append((Object)(this.isComponent ? "component" : "")).append(new Object[]{"custom score name of", this.entries}).append(new Object[]{"for", this.objective}).toString();
    }

    static {
        if (!Util.IS_RUNNING_FOLIA && SkBee.getPlugin().getPluginConfig().ELEMENTS_SCOREBOARD && Skript.methodExists(Score.class, (String)"customName", (Class[])new Class[0])) {
            Skript.registerExpression(ExprObjectiveScoreCustomName.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[:component] custom score name of %entities/strings% for %objective%"});
        }
    }
}

