/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Sign Line")
@Description(value={"Get/set lines of a sign with text components. Optionally set the front/back of a sign. (Defaults to front)", "\nNOTE: Setting the back of a sign requires Minecraft 1.20+"})
@Examples(value={"set sign line 1 of target block to mini message from \"<rainbow>LINE ONE\"", "set sign line 2 of target block to translate component from \"item.minecraft.diamond_sword\"", "set {_line1} to sign line 1 of target block", "set {_line1} to front sign line 1 of target block", "set back sign line 1 of {_sign} to mini message from \"<rainbow>LINE ONE\""})
@Since(value={"2.4.0, 2.11.0 (front|back)"})
public class ExprSignLines
extends PropertyExpression<Block, ComponentWrapper> {
    private Expression<Number> signLine;
    private boolean front;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[1]);
        this.signLine = exprs[0];
        this.front = !parseResult.hasTag("back");
        return true;
    }

    protected ComponentWrapper[] get(Event event, Block[] source) {
        Number signLineSingle = (Number)this.signLine.getSingle(event);
        if (signLineSingle == null) {
            return null;
        }
        int signLine = signLineSingle.intValue();
        if (signLine > 4 || signLine < 1) {
            return null;
        }
        return (ComponentWrapper[])this.get(source, block -> ComponentWrapper.getSignLine(block, signLine - 1, this.front));
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ComponentWrapper.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            Object object = delta[0];
            if (!(object instanceof ComponentWrapper)) {
                return;
            }
            ComponentWrapper component = (ComponentWrapper)object;
            Number signLineSingle = (Number)this.signLine.getSingle(event);
            if (signLineSingle == null) {
                return;
            }
            int signLine = signLineSingle.intValue();
            if (signLine > 4 || signLine < 1) {
                return;
            }
            --signLine;
            for (Block block : (Block[])this.getExpr().getArray(event)) {
                component.setBlockLine(block, signLine, this.front);
            }
        }
    }

    @NotNull
    public Class<? extends ComponentWrapper> getReturnType() {
        return ComponentWrapper.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String front = this.front ? "front" : "back";
        return front + " sign line " + this.signLine.toString(e, d) + " of " + this.getExpr().toString(e, d);
    }

    static {
        ExprSignLines.register(ExprSignLines.class, ComponentWrapper.class, (String)"[(front|:back)] sign line %number%", (String)"blocks");
    }
}

