/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.util.Util;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Team Prefix/Suffix")
@Description(value={"Get/set prefix/suffix of teams using components."})
@Examples(value={"set component team prefix of team of player to mini message from \"<color:grey>[<color:aqua>OWNER<color:grey>] \""})
@Since(value={"2.4.0"})
public class ExprTeamPrefixComp
extends SimplePropertyExpression<Team, ComponentWrapper> {
    private boolean prefix;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.prefix = parseResult.mark == 0;
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public ComponentWrapper convert(Team team) {
        return ComponentWrapper.fromComponent(this.prefix ? team.prefix() : team.suffix());
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ComponentWrapper.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Team[] teamArray = delta[0];
        if (teamArray instanceof ComponentWrapper) {
            ComponentWrapper component = (ComponentWrapper)teamArray;
            if (mode == Changer.ChangeMode.SET) {
                for (Team team : (Team[])this.getExpr().getArray(event)) {
                    if (this.prefix) {
                        component.setTeamPrefix(team);
                        continue;
                    }
                    component.setTeamSuffix(team);
                }
            }
        }
    }

    @NotNull
    public Class<? extends ComponentWrapper> getReturnType() {
        return ComponentWrapper.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "component team prefix";
    }

    static {
        if (!Util.IS_RUNNING_FOLIA && SkBee.getPlugin().getPluginConfig().ELEMENTS_SCOREBOARD) {
            ExprTeamPrefixComp.register(ExprTeamPrefixComp.class, ComponentWrapper.class, (String)"component team (prefix|1:suffix)", (String)"teams");
        }
    }
}

