/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.tickmanager.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.ServerTickManager;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Server Tick - Is Server Frozen/Running Normally")
@Description(value={"Checks if the server is currently frozen/running normally.", "When the server is running normally it indicates that the server is not currently frozen.", "See [**Tick Command**](https://minecraft.wiki/w/Commands/tick) on McWiki for more details.", "Requires Minecraft 1.20.4+"})
@Examples(value={"if server is frozen:", "\tteleport all players to spawn of world \"world\"", "if server is running normally:", "\tkill all sheep"})
@Since(value={"3.1.0"})
public class CondServerTickServerFrozen
extends Condition {
    private boolean normal;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setNegated(parseResult.hasTag("neg"));
        this.normal = parseResult.hasTag("normal");
        return true;
    }

    public boolean check(Event event) {
        ServerTickManager tickManager = Bukkit.getServerTickManager();
        return !this.isNegated() == (this.normal ? tickManager.isRunningNormally() : tickManager.isFrozen());
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        String is = this.isNegated() ? "is not" : "is";
        String normal = this.normal ? " running normally" : " frozen";
        return "server " + is + normal;
    }

    static {
        Skript.registerCondition(CondServerTickServerFrozen.class, (String[])new String[]{"(server|game) (is|neg:(isn't|is not)) [currently] (frozen|normal:running normally)"});
    }
}

