/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.tickmanager.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Server Tick - Frozen State")
@Description(value={"Get/set the frozen tick state of the server.", "See [**Tick Command**](https://minecraft.wiki/w/Commands/tick) on McWiki for more details.", "Requires Minecraft 1.20.4+"})
@Examples(value={"set server frozen state to true", "if server frozen state = false:"})
@Since(value={"3.1.0"})
public class ExprServerTickFrozenState
extends SimpleExpression<Boolean> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        return true;
    }

    @Nullable
    protected Boolean[] get(Event event) {
        return new Boolean[]{Bukkit.getServerTickManager().isFrozen()};
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object object;
        if (mode == Changer.ChangeMode.SET && delta != null && (object = delta[0]) instanceof Boolean) {
            Boolean frozen = (Boolean)object;
            Bukkit.getServerTickManager().setFrozen(frozen.booleanValue());
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "server frozen state";
    }

    static {
        Skript.registerExpression(ExprServerTickFrozenState.class, Boolean.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"server (frozen|freeze) state"});
    }
}

