/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.villager.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Merchant - Create")
@Description(value={"Creates a new Merchant object with a title."})
@Examples(value={"set {_merch} to new merchant named \"Le-Merchant\""})
@Since(value={"1.17.0"})
public class ExprMerchant
extends SimpleExpression<Merchant> {
    private Expression<String> name;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.name = exprs[0];
        return true;
    }

    @Nullable
    protected Merchant[] get(Event event) {
        String name = (String)this.name.getSingle(event);
        if (name != null) {
            Merchant merchant = Bukkit.createMerchant((String)name);
            return new Merchant[]{merchant};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Merchant> getReturnType() {
        return Merchant.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "new merchant named " + this.name.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprMerchant.class, Merchant.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[new ]merchant named %string%"});
    }
}

