/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.villager.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.MerchantRecipe;
import org.jetbrains.annotations.Nullable;

@Name(value="Merchant Recipe - Values")
@Description(value={"Represents different number values of a merchant recipe."})
@Examples(value={"set {_uses} to merchant recipe uses of {_recipe}", "set merchant recipe demand of {_recipe} to 2"})
@Since(value={"3.12.0"})
public class ExprMerchantRecipeValues
extends SimpleExpression<Number> {
    private int pattern;
    private Expression<MerchantRecipe> recipe;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.pattern = parseResult.mark;
        this.recipe = exprs[0];
        return true;
    }

    protected Number @Nullable [] get(Event event) {
        MerchantRecipe recipe = (MerchantRecipe)this.recipe.getSingle(event);
        if (recipe == null) {
            return null;
        }
        Number num = switch (this.pattern) {
            case 1 -> recipe.getMaxUses();
            case 2 -> Float.valueOf(recipe.getPriceMultiplier());
            case 3 -> recipe.getSpecialPrice();
            case 4 -> recipe.getUses();
            case 5 -> recipe.getVillagerExperience();
            default -> recipe.getDemand();
        };
        return new Number[]{num};
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        Object object;
        if (delta != null && (object = delta[0]) instanceof Number) {
            Number value = (Number)object;
            if (mode == Changer.ChangeMode.SET) {
                MerchantRecipe recipe = (MerchantRecipe)this.recipe.getSingle(event);
                if (recipe == null) {
                    return;
                }
                switch (this.pattern) {
                    case 1: {
                        recipe.setMaxUses(value.intValue());
                        break;
                    }
                    case 2: {
                        recipe.setPriceMultiplier((float)value.intValue());
                        break;
                    }
                    case 3: {
                        recipe.setSpecialPrice(value.intValue());
                        break;
                    }
                    case 4: {
                        recipe.setUses(value.intValue());
                        break;
                    }
                    case 5: {
                        recipe.setVillagerExperience(value.intValue());
                        break;
                    }
                    default: {
                        recipe.setDemand(value.intValue());
                    }
                }
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        String type = switch (this.pattern) {
            case 1 -> "max uses";
            case 2 -> "price multiplier";
            case 3 -> "special price";
            case 4 -> "uses";
            case 5 -> "villager experience";
            default -> "demand";
        };
        return "merchant recipe " + type + " of " + this.recipe.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprMerchantRecipeValues.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"merchant recipe (0:demand|1:max uses|2:price multiplier|3:special price|4:uses|5:villager experience) of %merchantrecipe%"});
    }
}

