/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.worldborder.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.WorldBorder;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="WorldBorder - Location Within")
@Description(value={"Check if a location is within a world border."})
@Examples(value={"if location of player is within world border of world of player:"})
@Since(value={"1.17.0"})
public class CondWorldBorderInside
extends Condition {
    private Expression<Location> locations;
    private Expression<WorldBorder> worldBorder;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.locations = exprs[0];
        this.worldBorder = exprs[1];
        this.setNegated(i == 1);
        return true;
    }

    public boolean check(Event event) {
        return this.locations.check(event, location -> this.worldBorder.check(event, worldBorder -> worldBorder.isInside(location), this.isNegated()));
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String not = this.isNegated() ? " is/are not" : " is/are";
        return this.locations.toString(e, d) + not + " within " + this.worldBorder.toString(e, d);
    }

    static {
        PropertyCondition.register(CondWorldBorderInside.class, (String)"within [border] %worldborder%", (String)"locations");
    }
}

