/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.worldborder.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.WorldBorder;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="WorldBorder - Warning Time")
@Description(value={"Get/set the warning time of a world border."})
@Examples(value={"set warning time of world border of world \"world\" to 5 seconds"})
@Since(value={"1.17.0"})
public class ExprWorldBorderWarningTime
extends SimplePropertyExpression<WorldBorder, Timespan> {
    @Nullable
    public Timespan convert(WorldBorder worldBorder) {
        return new Timespan(Timespan.TimePeriod.SECOND, (long)worldBorder.getWarningTime());
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Timespan.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Timespan timespan = (Timespan)delta[0];
        if (timespan == null) {
            return;
        }
        int seconds = (int)(timespan.getAs(Timespan.TimePeriod.TICK) / 20L);
        for (WorldBorder border : (WorldBorder[])this.getExpr().getArray(event)) {
            border.setWarningTime(seconds);
        }
    }

    @NotNull
    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "warning time";
    }

    static {
        ExprWorldBorderWarningTime.register(ExprWorldBorderWarningTime.class, Timespan.class, (String)"[border] warning time", (String)"worldborders");
    }
}

