/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.game.checkers;

import com.shanebeestudios.skbee.game.checkers.Game;
import com.shanebeestudios.skbee.game.checkers.PieceColor;
import com.shanebeestudios.skbee.game.checkers.PieceType;
import java.util.ArrayList;

public class Piece {
    public PieceType type;
    public PieceColor color;
    public int x;
    public int y;

    public Piece(int x, int y) {
        this(null, null, x, y);
    }

    public Piece(PieceType type, PieceColor color, int x, int y) {
        this.type = type;
        this.color = color;
        this.x = x;
        this.y = y;
    }

    public ArrayList<int[]> getMoves(Game game) {
        int direction = this.color == PieceColor.RED ? -1 : 1;
        ArrayList<int[]> moves = new ArrayList<int[]>();
        Piece piece = new Piece(-1, -1);
        if (direction == -1 && this.y > 0 || direction == 1 && this.y < 7) {
            if (this.x > 0) {
                piece = game.getPiece(this.x - 1, this.y + direction);
            }
            if (this.x > 0 && piece.isNull()) {
                moves.add(new int[]{this.x - 1, this.y + direction});
            } else if (this.x > 1 && (direction == -1 && this.y > 1 || direction == 1 && this.y < 6) && game.getPiece(this.x - 2, this.y + direction * 2).isNull() && piece.color != this.color) {
                moves.add(new int[]{this.x - 2, this.y + direction * 2});
            }
            if (this.x < 7) {
                piece = game.getPiece(this.x + 1, this.y + direction);
            }
            if (this.x < 7 && piece.isNull()) {
                moves.add(new int[]{this.x + 1, this.y + direction});
            } else if (this.x < 6 && (direction == -1 && this.y > 1 || direction == 1 && this.y < 6) && game.getPiece(this.x + 2, this.y + direction * 2).isNull() && piece.color != this.color) {
                moves.add(new int[]{this.x + 2, this.y + direction * 2});
            }
        }
        if (this.type == PieceType.QUEEN_BEE && (direction == -1 && this.y < 7 || direction == 1 && this.y > 0)) {
            if (this.x > 0) {
                piece = game.getPiece(this.x - 1, this.y - direction);
            }
            if (this.x > 0 && piece.isNull()) {
                moves.add(new int[]{this.x - 1, this.y - direction});
            } else if (this.x > 1 && (-direction == -1 && this.y > 1 || -direction == 1 && this.y < 6) && game.getPiece(this.x - 2, this.y - direction * 2).isNull() && piece.color != this.color) {
                moves.add(new int[]{this.x - 2, this.y - direction * 2});
            }
            if (this.x < 7) {
                piece = game.getPiece(this.x + 1, this.y - direction);
            }
            if (this.x < 7 && piece.isNull()) {
                moves.add(new int[]{this.x + 1, this.y - direction});
            } else if (this.x < 6 && (-direction == -1 && this.y > 1 || -direction == 1 && this.y < 6) && game.getPiece(this.x + 2, this.y - direction * 2).isNull() && piece.color != this.color) {
                moves.add(new int[]{this.x + 2, this.y - direction * 2});
            }
        }
        return moves;
    }

    public boolean isNull() {
        return this.type == null || this.color == null;
    }
}

