/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.game.checkers;

import com.shanebeestudios.skbee.game.checkers.Game;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;

public final class PieceType
extends Enum<PieceType> {
    public static final /* enum */ PieceType WORKER_BEE = new PieceType("/assets/workerbee.png");
    public static final /* enum */ PieceType QUEEN_BEE = new PieceType("/assets/queenbee.png");
    public final Image red;
    public final Image blue;
    private static final /* synthetic */ PieceType[] $VALUES;

    public static PieceType[] values() {
        return (PieceType[])$VALUES.clone();
    }

    public static PieceType valueOf(String name) {
        return Enum.valueOf(PieceType.class, name);
    }

    private PieceType(String location) {
        BufferedImage buffRed = PieceType.tint(this.loadImage(location), new Color(248, 57, 57));
        this.red = new ImageIcon(buffRed).getImage();
        BufferedImage buffBlue = PieceType.tint(this.loadImage(location), new Color(54, 54, 246));
        this.blue = new ImageIcon(buffBlue).getImage();
    }

    public BufferedImage loadImage(String location) {
        URL url = Game.class.getResource(location);
        assert (url != null);
        ImageIcon icon = new ImageIcon(url);
        Image image = icon.getImage();
        BufferedImage buffImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics g = buffImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        return buffImage;
    }

    public static BufferedImage tint(BufferedImage image, Color color) {
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                Color pixelColor = new Color(image.getRGB(x, y), true);
                int r = (pixelColor.getRed() + color.getRed()) / 2;
                int g = (pixelColor.getGreen() + color.getGreen()) / 2;
                int b = (pixelColor.getBlue() + color.getBlue()) / 2;
                int a = pixelColor.getAlpha();
                int rgba = a << 24 | r << 16 | g << 8 | b;
                image.setRGB(x, y, rgba);
            }
        }
        return image;
    }

    private static /* synthetic */ PieceType[] $values() {
        return new PieceType[]{WORKER_BEE, QUEEN_BEE};
    }

    static {
        $VALUES = PieceType.$values();
    }
}

