/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.bound;

import com.google.common.base.Preconditions;
import com.shanebeestudios.skbee.api.wrapper.LazyLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.entity.Entity;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SerializableAs(value="Bound")
public class Bound
implements ConfigurationSerializable {
    private final String world;
    private String id;
    private final boolean temporary;
    private boolean full;
    private List<UUID> owners = new ArrayList<UUID>();
    private List<UUID> members = new ArrayList<UUID>();
    private Map<String, Object> values = new HashMap<String, Object>();
    private BoundingBox boundingBox;
    private BoundingBox fullBoundBoxCache;

    public Bound(String world, String id, BoundingBox boundingBox, boolean temporary) {
        this.world = world;
        this.id = id;
        this.boundingBox = boundingBox;
        this.temporary = temporary;
    }

    public Bound(Location location, Location location2, String id, boolean temporary, boolean usingBlocks) {
        Preconditions.checkArgument((location.getWorld() == location2.getWorld() ? 1 : 0) != 0, (Object)"Worlds have to match");
        this.world = location.getWorld().getName();
        this.id = id;
        if (usingBlocks) {
            Block block1 = location.getBlock();
            Block block2 = location2.getBlock();
            this.boundingBox = BoundingBox.of((Block)block1, (Block)block2);
        } else {
            this.boundingBox = BoundingBox.of((Location)location, (Location)location2);
        }
        this.temporary = temporary;
    }

    public boolean isInRegion(@NotNull Location loc) {
        World w = loc.getWorld();
        if (w != null && w.getName().equals(this.world)) {
            return this.getCachedBoundingBox().contains(loc.toVector());
        }
        return false;
    }

    public boolean overlaps(Bound bound) {
        if (bound.world.equals(this.world)) {
            return this.getCachedBoundingBox().overlaps(bound.getCachedBoundingBox());
        }
        return false;
    }

    public boolean overlaps(Location l1, Location l2) {
        if (l1.getWorld() != null && l1.getWorld() == l2.getWorld()) {
            return this.getCachedBoundingBox().overlaps(l1.toVector(), l2.toVector());
        }
        return false;
    }

    public List<Entity> getEntities(Class<? extends Entity> type) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        World world = this.getWorld();
        if (world != null) {
            BoundingBox box = this.getCachedBoundingBox();
            Collection nearbyEntities = world.getNearbyEntities(box, entity -> type.isAssignableFrom(entity.getClass()));
            entities.addAll(nearbyEntities);
        }
        return entities;
    }

    @NotNull
    public List<Block> getBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        World w = this.getWorld();
        if (w == null) {
            return blocks;
        }
        Location min = this.getLesserCorner();
        Location max = this.getGreaterCorner();
        for (int x = min.getBlockX(); x < max.getBlockX(); ++x) {
            for (int y = min.getBlockY(); y < max.getBlockY(); ++y) {
                for (int z = min.getBlockZ(); z < max.getBlockZ(); ++z) {
                    blocks.add(w.getBlockAt(x, y, z));
                }
            }
        }
        return blocks;
    }

    @Nullable
    public World getWorld() {
        return Bukkit.getWorld((String)this.world);
    }

    public String getWorldName() {
        return this.world;
    }

    public Location getGreaterCorner() {
        Vector max = this.getCachedBoundingBox().getMax();
        return new Location(this.getWorld(), max.getX(), max.getY(), max.getZ());
    }

    public Location getLesserCorner() {
        Vector min = this.getCachedBoundingBox().getMin();
        return new Location(this.getWorld(), min.getX(), min.getY(), min.getZ());
    }

    public Location getCenter() {
        Vector center = this.getCachedBoundingBox().getCenter();
        return new Location(this.getWorld(), center.getX(), center.getY(), center.getZ());
    }

    public void resize(Location loc1, Location loc2) {
        this.resize(loc1, loc2, false);
    }

    public void resize(Location loc1, Location loc2, boolean usingBlocks) {
        Preconditions.checkArgument((loc1.getWorld() == loc2.getWorld() ? 1 : 0) != 0, (Object)"Worlds have to match");
        Preconditions.checkArgument((boolean)loc1.getWorld().getName().equalsIgnoreCase(this.world), (Object)"World cannot be changed!");
        this.boundingBox = usingBlocks ? BoundingBox.of((Block)loc1.getBlock(), (Block)loc2.getBlock()) : BoundingBox.of((Location)loc1, (Location)loc2);
        this.fullBoundBoxCache = null;
    }

    public Bound copy(String newId) {
        Location lesserCorner = this.getLesserCorner().clone();
        Location greaterCorner = this.getGreaterCorner().clone();
        Bound newBound = new Bound(this.world, newId, this.boundingBox.clone(), this.temporary);
        newBound.setOwners(this.getOwners());
        newBound.setMembers(this.getMembers());
        newBound.values = this.values;
        return newBound;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<UUID> getOwners() {
        return this.owners;
    }

    public void setOwners(List<UUID> owners) {
        this.owners = new ArrayList<UUID>(owners);
    }

    public void clearOwners() {
        this.owners.clear();
    }

    public void addOwner(UUID owner) {
        if (!this.owners.contains(owner)) {
            this.owners.add(owner);
        }
    }

    public void removeOwner(UUID owner) {
        this.owners.remove(owner);
    }

    public List<UUID> getMembers() {
        return this.members;
    }

    public void setMembers(List<UUID> members) {
        this.members = new ArrayList<UUID>(members);
    }

    public void clearMembers() {
        this.members.clear();
    }

    public void addMember(UUID member) {
        if (!this.members.contains(member)) {
            this.members.add(member);
        }
    }

    public void removeMember(UUID member) {
        this.members.remove(member);
    }

    public void setValue(String key, Object value) {
        if (value instanceof Location) {
            Location location = (Location)value;
            this.values.put(key, (Object)new LazyLocation(location));
        } else {
            this.values.put(key, value);
        }
    }

    public void deleteValue(String key) {
        this.values.remove(key);
    }

    public void clearValues() {
        this.values = new HashMap<String, Object>();
    }

    public Object getValue(String key) {
        Object o = this.values.get(key);
        if (o instanceof LazyLocation) {
            LazyLocation lazyLocation = (LazyLocation)((Object)o);
            return lazyLocation.getLocation();
        }
        return o;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    private BoundingBox getCachedBoundingBox() {
        if (this.isFull()) {
            if (this.fullBoundBoxCache != null) {
                return this.fullBoundBoxCache;
            }
            BoundingBox box = this.boundingBox.clone();
            World world = this.getWorld();
            int minY = world != null ? world.getMinHeight() : 0;
            int maxY = world != null ? world.getMaxHeight() - 1 : 255;
            this.fullBoundBoxCache = box.resize(box.getMinX(), (double)minY, box.getMinZ(), box.getMaxX(), (double)maxY, box.getMaxZ());
            return this.fullBoundBoxCache;
        }
        return this.boundingBox;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isFull() {
        return this.full;
    }

    public void setFull(boolean full) {
        this.full = full;
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Bound)) {
            return false;
        }
        Bound other = (Bound)obj;
        return this.world.equals(other.world) && this.id.equals(other.id);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("id", this.id);
        result.put("world", this.world);
        result.put("boundingbox", this.boundingBox);
        result.put("full", this.full);
        ArrayList owners = new ArrayList();
        this.owners.forEach(uuid -> owners.add(uuid.toString()));
        ArrayList members = new ArrayList();
        this.members.forEach(uuid -> members.add(uuid.toString()));
        result.put("owners", owners);
        result.put("members", members);
        this.values.values().removeIf(Objects::isNull);
        result.put("values", this.values);
        return result;
    }

    public static Bound deserialize(Map<String, Object> args) {
        Bound bound;
        String world = (String)args.get("world");
        String id = String.valueOf(args.get("id"));
        if (args.containsKey("boundingbox")) {
            BoundingBox box = (BoundingBox)args.get("boundingbox");
            bound = new Bound(world, id, box, false);
        } else {
            int x = ((Number)args.get("x1")).intValue();
            int y = ((Number)args.get("y1")).intValue();
            int z = ((Number)args.get("z1")).intValue();
            int x2 = ((Number)args.get("x2")).intValue();
            int y2 = ((Number)args.get("y2")).intValue();
            int z2 = ((Number)args.get("z2")).intValue();
            BoundingBox box = new BoundingBox((double)x, (double)y, (double)z, (double)x2, (double)y2, (double)z2);
            bound = new Bound(world, id, box, false);
        }
        if (args.containsKey("full")) {
            bound.setFull((Boolean)args.get("full"));
        }
        if (args.containsKey("owners")) {
            List owners = (List)args.get("owners");
            ArrayList<UUID> ownerUUIDs = new ArrayList<UUID>();
            owners.forEach(owner -> {
                UUID uuid = UUID.fromString(owner);
                ownerUUIDs.add(uuid);
            });
            bound.setOwners(ownerUUIDs);
        }
        if (args.containsKey("members")) {
            List members = (List)args.get("members");
            ArrayList<UUID> memberUUIDs = new ArrayList<UUID>();
            members.forEach(member -> {
                UUID uuid = UUID.fromString(member);
                memberUUIDs.add(uuid);
            });
            bound.setMembers(memberUUIDs);
        }
        if (args.containsKey("values")) {
            bound.values = (Map)args.get("values");
        }
        return bound;
    }
}

