/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.generator;

import ch.njol.skript.lang.Trigger;
import com.shanebeestudios.skbee.api.generator.event.BlockPopulateEvent;
import com.shanebeestudios.skbee.api.generator.event.ChunkGenEvent;
import com.shanebeestudios.skbee.api.generator.event.HeightGenEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkGenerator
extends org.bukkit.generator.ChunkGenerator {
    private Trigger noiseGenTrigger;
    private Trigger surfaceGenTrigger;
    private Trigger chunkGenTrigger;
    private Trigger heightGenTrigger;
    private Trigger blockPopTrigger;
    private boolean vanillaDecor = false;
    private boolean vanillaCaves = false;
    private boolean vanillaStructures = false;
    private boolean vanillaMobs = false;
    private Location fixedSpawnLocation = null;

    public void setNoiseGenTrigger(Trigger noiseGenTrigger) {
        this.noiseGenTrigger = noiseGenTrigger;
    }

    public void setSurfaceGenTrigger(Trigger surfaceGenTrigger) {
        this.surfaceGenTrigger = surfaceGenTrigger;
    }

    public void setChunkGenTrigger(Trigger chunkGenTrigger) {
        this.chunkGenTrigger = chunkGenTrigger;
    }

    public void setHeightGenTrigger(Trigger heightGenTrigger) {
        this.heightGenTrigger = heightGenTrigger;
    }

    public void setBlockPopTrigger(Trigger blockPopTrigger) {
        this.blockPopTrigger = blockPopTrigger;
    }

    public void setVanillaDecor(boolean vanillaDecor) {
        this.vanillaDecor = vanillaDecor;
    }

    public void setVanillaCaves(boolean vanillaCaves) {
        this.vanillaCaves = vanillaCaves;
    }

    public void setVanillaStructures(boolean vanillaStructures) {
        this.vanillaStructures = vanillaStructures;
    }

    public void setVanillaMobs(boolean vanillaMobs) {
        this.vanillaMobs = vanillaMobs;
    }

    public void setFixedSpawnLocation(Location fixedSpawnLocation) {
        this.fixedSpawnLocation = fixedSpawnLocation;
    }

    public void generateNoise(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.ChunkData chunkData) {
        if (this.noiseGenTrigger != null) {
            ChunkGenEvent chunkGenEvent = new ChunkGenEvent(chunkData, chunkX, chunkZ);
            this.noiseGenTrigger.execute((Event)chunkGenEvent);
        }
    }

    public void generateSurface(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.ChunkData chunkData) {
        if (this.surfaceGenTrigger != null) {
            ChunkGenEvent chunkGenEvent = new ChunkGenEvent(chunkData, chunkX, chunkZ, this);
            this.surfaceGenTrigger.execute((Event)chunkGenEvent);
        } else if (this.chunkGenTrigger != null) {
            ChunkGenEvent chunkGenEvent = new ChunkGenEvent(chunkData, chunkX, chunkZ);
            this.chunkGenTrigger.execute((Event)chunkGenEvent);
        }
    }

    public int getBaseHeight(@NotNull WorldInfo worldInfo, @NotNull Random random, int x, int z, @NotNull HeightMap heightMap) {
        if (this.heightGenTrigger != null) {
            HeightGenEvent heightGenEvent = new HeightGenEvent(new Location(null, (double)x, 0.0, (double)z));
            this.heightGenTrigger.execute((Event)heightGenEvent);
            return heightGenEvent.getHeight();
        }
        return super.getBaseHeight(worldInfo, random, x, z, heightMap);
    }

    public boolean shouldGenerateNoise() {
        return this.chunkGenTrigger == null && this.noiseGenTrigger == null;
    }

    public boolean shouldGenerateSurface() {
        return this.chunkGenTrigger == null && this.surfaceGenTrigger == null;
    }

    public boolean shouldGenerateCaves() {
        return this.vanillaCaves;
    }

    public boolean shouldGenerateDecorations() {
        return this.vanillaDecor;
    }

    public boolean shouldGenerateStructures() {
        return this.vanillaStructures;
    }

    public boolean shouldGenerateMobs() {
        return this.vanillaMobs;
    }

    @Nullable
    public Location getFixedSpawnLocation(@NotNull World world, @NotNull Random random) {
        if (this.fixedSpawnLocation != null) {
            Location clone = this.fixedSpawnLocation.clone();
            clone.setWorld(world);
            return clone;
        }
        return null;
    }

    @NotNull
    public List<BlockPopulator> getDefaultPopulators(@NotNull World world) {
        ArrayList<BlockPopulator> populators = new ArrayList<BlockPopulator>();
        populators.add(new BlockPopulator(){

            public void populate(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull LimitedRegion limitedRegion) {
                if (ChunkGenerator.this.blockPopTrigger != null) {
                    BlockPopulateEvent populateEvent = new BlockPopulateEvent(limitedRegion, chunkX, chunkZ, random);
                    ChunkGenerator.this.blockPopTrigger.execute((Event)populateEvent);
                }
            }
        });
        return populators;
    }
}

